package com.rocoinfo.rocomall.repository.activity;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.activity.AuctionActivityRecord;
import com.rocoinfo.rocomall.entity.activity.AuctionRefundRecord;
import com.rocoinfo.rocomall.repository.MyBatisRepository;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@MyBatisRepository
public interface AuctionActivityRecordDao extends CrudDao<AuctionActivityRecord> {

	List<AuctionActivityRecord> findAuctionTopN(@Param("activityId") Long activityId, @Param("topNum") Integer topNum);

	List<AuctionActivityRecord> search(Map<String, Object> params);

	AuctionActivityRecord searchLastRecordByActivityId(@Param("activityId") Long activityId);

	AuctionActivityRecord findLastRecordByActivityIdAndUserId(@Param("userId") Long userId, @Param("activityId") Long activityId);

	int findOfferNumByActivityIdAndUserId(@Param("userId") Long userId, @Param("activityId") Long activityId);

	void batchInsertUnHitRefundRecords(@Param("activityId") Long activityId, @Param("topnUserIdList") List<Long> topNUsrIdList);

	void batchInsertHitRefundRecords(final List<AuctionRefundRecord> auctionRefundList);

	List<AuctionRefundRecord> findAuctionRefundRecords(@Param("fetchSize") Integer fetchSize);

	void updateRefundRecordStatus(AuctionRefundRecord refundRecord);

	int findMaxCent(@Param("activityId") Long activityId);

	List<AuctionRefundRecord> queryAuctionRecordsByUserId(@Param("userId") Long userId);
}
