package com.rocoinfo.rocomall.repository.cent;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.cent.CentBudget;
import com.rocoinfo.rocomall.repository.MyBatisRepository;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author zhangmin
 */
@MyBatisRepository
public interface CentsBudgetDao extends CrudDao<CentBudget>{

	long countName(String budgetName);

	void increaseAllocatedBudget(@Param("budgetId") long budgetId, @Param("centIncrement") int centIncrement);
	
	/**
	 * 计算已经分配的积分预算
	 */
	@Deprecated
	int countAllocatedCentBudget(Long id);
	
	List<CentBudget> findCentBudgets(@Param("useable") Boolean useable, @Param("hasBudgetBalance") Boolean hasBudgetBalance);

}