package com.rocoinfo.rocomall.repository.insurance;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.insurance.InsuredInfo;
import com.rocoinfo.rocomall.repository.MyBatisRepository;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <dl>
 * <dd>描述: 受保人信息Dao</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015/12/29 15:48</dd>
 * <dd>@author：huyt</dd>
 * </dl>
 */
@MyBatisRepository
public interface InsuredInfoDao extends CrudDao<InsuredInfo> {

    /**
     * 根据用户名(手机号或者openid)查询登录用户的信息
     *
     * @param username 手机号或者openid
     * @return 登录用户信息
     */
    List<InsuredInfo> findByUsername(String username);

    /**
     * 根据登录用户的id查找登录用户所关联的用户(投保人和被保险人)信息
     *
     * @param id 用户id
     * @return 用户所关联的用户(投保人和被保险人)信息
     */
    List<InsuredInfo> findByRelationId(Long id);

    /**
     * 创建用户信息(用户名为手机号或者openid),用户信息关联投保人信息
     *
     * @param id       投保人id
     * @param username 用户名(手机号或者openid)
     */
    void createUserInfo(@Param("id") Long id, @Param("username") String username);

    /**
     * 创建用户之间的关联关系(投保人与登录用户之间 N:1)
     *
     * @param userId     登录用户信息(投保人信息)
     * @param relationId 被保险人信息
     */
    void createUserRelationship(@Param("userId") Long userId, @Param("relationId") Long relationId);

    /**
     * 根据身份证号码查询保险人或被保险人信息
     * 因为创建用户的时候可能存在空证件号码 所以可能查处多条 SelectOne会报错
     * 所以结果用List接收
     *
     * @return
     */
    List<InsuredInfo> findByCardNo(String cardNo);

    /**
     * 查找投保人与被投保人之间的关系 0:不存在关系; 大于0:存在关系
     *
     * @param insuredId
     * @param relationId
     * @return
     */
    Long getRelationCount(@Param("insuredId") Long insuredId, @Param("relationId") Long relationId);
}
