package com.rocoinfo.rocomall.service;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.Address;

import java.util.List;

/**
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/8/13 上午10:05</dd>
 * <dd>创建人： weiys</dd>
 * </dl>
 */
public interface IAddressService extends IBaseService<Address> {
    /**
     * 根据用户id查询用户当前地址
     *
     * @param userId 用户id
     * @return
     */
    List<Address> findByUserId(Long userId);

    /**
     * 设置默认地址
     *
     * @param userId 用户id
     * @param id     需要设置为默认地址的记录id
     */
    boolean setDefault(Long userId, Long id);
}
