package com.rocoinfo.rocomall.service;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.CartItem;

import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>描述: </dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015/9/23 10:13</dd>
 * <dd>创建人：huyt</dd>
 * </dl>
 */
public interface ICartService extends IBaseService<CartItem> {

    void saveCardItems(final CartItem... items);


    List<CartItem> findCheckedCartItemListByUserId(final long userId);

    List<CartItem> findCartItemListByUserId(final long userId);


    List<CartItem> findCartItemListByUserAndSkuIdsIn(final long userId, List<Long> skuIds);

    CartItem getCartItemByUnitProdId(final long userId, final long unitProdId);


    void removeCartItemUnitProdId(final long userId, final Long... unitProdIds);

    void clearCartByUserId(final long userId);

    /**
     * 修改cartItem的购买数量
     */
    void modifyCardItemQuantity(final CartItem cartItem);


    /**
     * 更新用户选中购买的sku
     *
     * @param userId           用户Id
     * @param checkedSkuIdList 在购物车中被选中的skuId
     */
    void updateCartItemCheckedIn(final long userId, List<Long> checkedSkuIdList);

    /**
     * 批量修改购物车 Item的数量
     *
     * @param cartItemQtMap<ItemId, quantity>
     */
    void batchModifyCartItemQtMap(Map<Long, Integer> cartItemQtMap);


    /**
     * 汇总购物车skus数量，为了替换CookieUtil.cookieCartItemMap()
     *
     * @return
     */
    Map<Long, Integer> dbCartItemMap(Long loggedUserId);
}
