package com.rocoinfo.rocomall.service;

import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.dto.XhEditorUploadDto;
import com.rocoinfo.rocomall.service.impl.UploadService;
import com.rocoinfo.rocomall.service.impl.UploadService.UploadCategory;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;

/**
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/8/13 上午10:24</dd>
 * <dd>创建人： weiys</dd>
 * </dl>
 */
public interface IUploadService {

    /**
     * 保存上传的文件，返回文件保存路径. 文件将保存在临时目录。
     *
     * @param file           上传文件
     * @param uploadCategory 类别.文件会存储在该类别对应的子目录下。
     * @return 返回文件保存路径。如tmp/2014/09/04/1.jpg
     * @throws ServiceException 发生错误时
     */
    public String upload(MultipartFile file, UploadService.UploadCategory uploadCategory);

    /**
     * 保存上传的文件，返回文件保存路径. 文件将保存在临时目录。
     *
     * @param stream         输入流
     * @param uploadCategory 类别.文件会存储在该类别对应的子目录下。
     * @param ext            文件扩展名
     * @return 返回文件保存路径。如tmp/2014/09/04/1.jpg
     * @throws ServiceException 发生错误时
     */
    public String upload(InputStream stream, UploadService.UploadCategory uploadCategory, String ext);

    /**
     * 将文件从临时目录移至普通目录
     *
     * @param tmpPath 文件临时路径。如tmp/product/2014/09/04/1.jpg
     * @return 如果tmpPath是临时路径，则返回新路径，如product/2014/09/04/1.jpg。否则返回原路径tmpPath
     */
    public String submitPath(String tmpPath);

    /**
     * 将文件从临时目录移至普通目录 .获得文件对象
     *
     * @param path
     * @return
     * @author： 张文山
     * @创建时间：2015-9-11 上午11:19:24
     */
    public File submitPathAndGetfile(String path);

    public File getFileByPath(String path);

    /**
     * 将html中临时图片地址替换为永久图片地址.
     *
     * @param html 含有临时图片地址img标签的html.通常是前端富文本编辑器产生的。
     * @return 返回新html.已将临时图片地址替换为永久图片地址.
     */
    public String submitHtml(String html);

    /**
     * 该方法用于更新可能含有上传的文件路径的html。删除旧的不用的图片，保存新图片(从临时目录移至持久目录)。
     *
     * @param oldHtml 旧的可能含有上传的图片地址img标签的html
     * @param newHtml 新的可能含有上传的图片地址img标签的html
     * @return 返回新的html
     */
    public String updateHtml(String oldHtml, String newHtml);

    /**
     * 删除html中图片路径对应的图片文件
     *
     * @param html 可能引用上传文件的html
     * @return 返回删除的文件路径
     */
    public List<String> deleteByPathInHtml(String html);

    /**
     * 删除指定路径的单个文件
     *
     * @param path 上传的文件路径
     */
    public void delete(String path);

    /**
     * 删除临时目录中1天之前上传的文件
     */
    public void scheduleCleanTmpFile() throws ParseException, IOException;

    /**
     * 处理xhEditor上传。
     *
     * @param file           上传文件
     * @param uploadCategory 类别。文件会保存在该类别对应的目录下。
     * @return 返回符合xhEditor默认返回值格式的XhEditorUploadDto对象。
     */
    public XhEditorUploadDto xhEditorUpload(MultipartFile file, UploadService.UploadCategory uploadCategory);

    /**
     * 更新文件。需要删除旧文件。复制新文件
     *
     * @param path
     */
    public String updateFile(String path, String oldPath);

    /**
     * 通过路径获取文件类型
     *
     * @param path
     * @return
     */
    public UploadCategory parseCatalogType(String path);
}
