package com.rocoinfo.rocomall.service.cent;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.dto.admin.CentsImportExcelDto;
import com.rocoinfo.rocomall.entity.cent.CentApply;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>描述: </dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/8/28  下午2:23</dd>
 * <dd>创建人： weiys</dd>
 * </dl>
 */
public interface ICentApplyService extends IBaseService<CentApply>{

    public StatusDto importCent(String ruleCode,List<CentsImportExcelDto> dataList,Long userid);

    public Page<CentApply> searchScrollAddPage(Map<String, Object> params, Pageable pageable);
    
    /**
     * 手工增加积分
     *
     * @param ruleCode   积分规则编码
     * @param username   用户名
     * @param cent       积分值
     * @param expireDate 失效日期
     * @param loggedUserId 当前登录用户id
     * @return
     */
    StatusDto manualAddUserCent(String ruleCode, String username, Integer cent, Date expireDate, Long loggedUserId);
}
