package com.rocoinfo.rocomall.service.impl;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.Address;
import com.rocoinfo.rocomall.repository.AddressDao;
import com.rocoinfo.rocomall.service.IAddressService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 用户收货地址DAO Created by robin on 14-6-11. author yangxc
 */
@SuppressWarnings("all")
@Service
@Transactional
public class AddressService extends CrudService<AddressDao, Address> implements IAddressService {

    /**
     * 根据用户id查询用户当前地址
     *
     * @param userId 用户id
     * @return
     */
    @Override
    public List<Address> findByUserId(Long userId) {
        if (userId == null)
            return null;
        return this.entityDao.findByUserId(userId);
    }

    /**
     * 设置默认地址
     *
     * @param userId 用户id
     * @param id     需要设置为默认地址的记录id
     */
    @Override
    public boolean setDefault(Long userId, Long id) {
        if (userId == null || id == null)
            return false;
        this.entityDao.setUnDefaultByUserId(userId);
        this.entityDao.setDefault(userId, id);
        return true;
    }
}
