package com.rocoinfo.rocomall.service.impl;

import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.Adv;
import com.rocoinfo.rocomall.enumconst.AdvType;
import com.rocoinfo.rocomall.repository.AdvDao;
import com.rocoinfo.rocomall.service.IAdvService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <dl>
 * <dd>Description:广告管理 </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2016/6/30 10:28</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Service
@Transactional
public class AdvService extends CrudService<AdvDao, Adv> implements IAdvService{

    /**
     * 根据广告类型查询广告信息
     *
     * @param type  广告类型
     * @param count 需要的条数
     * @return
     */
    public List<Adv> findByType(AdvType type, int count) {
        List<Adv> list = Lists.newArrayList();
        if (type != null)
            list = this.entityDao.findByType(type);
        // 截取指定长度的list
        if (CollectionUtils.isNotEmpty(list) && list.size() > count && count > 0)
            list = list.subList(0, count);
        return list;
    }
}
