package com.rocoinfo.rocomall.service.impl;

import com.rocoinfo.rocomall.redis.JedisTemplate;
import com.rocoinfo.rocomall.service.IKuaiDi100Service;
import com.rocoinfo.rocomall.utils.JsonUtils;
import com.rocoinfo.rocomall.utils.KuaiDi100Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class KuaiDi100Service implements IKuaiDi100Service{

	@Autowired
	private JedisTemplate jedisTemplate;
	
	@Override
	public Map<String, Object> search(String com, String orderNo) {
		if(com == null || orderNo == null){
			Map<String, Object> map = new HashMap<String,Object>();
			map.put("status", 0);
			return map;
		}
		String key = com+"_kuaidi_"+orderNo;
		String value = jedisTemplate.get(key);
		if(value == null){
			value = KuaiDi100Utils.search(com, orderNo);
			jedisTemplate.setex(key, value, 60*60*4);
		}
		Map<String,Object> map = (Map<String,Object>)JsonUtils.fromJson(value, Map.class);
		return map;
	}

}
