package com.rocoinfo.rocomall.service.impl.cent;

import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.dto.admin.CentsImportExcelDto;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.cent.CentApply;
import com.rocoinfo.rocomall.entity.cent.CentApply.Type;
import com.rocoinfo.rocomall.entity.cent.CentRule;
import com.rocoinfo.rocomall.entity.cent.Cents;
import com.rocoinfo.rocomall.entity.cent.Cents.Status;
import com.rocoinfo.rocomall.repository.cent.CentApplyDao;
import com.rocoinfo.rocomall.repository.cent.CentsDao;
import com.rocoinfo.rocomall.service.IUserService;
import com.rocoinfo.rocomall.service.cent.ICentApplyService;
import com.rocoinfo.rocomall.service.cent.ICentRuleService;
import com.rocoinfo.rocomall.utils.CodeGenerator;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;


/**
 * weiys
 */
@SuppressWarnings("all")
@Service
@Transactional(rollbackFor = Exception.class)
public class CentApplyService extends CrudService<CentApplyDao, CentApply> implements ICentApplyService {

    @Autowired
    private CentsDao centsDao;

    @Autowired
    private CodeGenerator codeGenerator;

    @Autowired
    private IUserService userService;

    @Autowired
    private ICentRuleService centRuleService;

    private static final int IMPORT_MAX_RECORD = 10000;


    public StatusDto importCent(String ruleCode, List<CentsImportExcelDto> dataList, Long userid) {


        StatusDto statusDto = new StatusDto();
        statusDto.setCode(Constants.RESP_STATUS_CODE_FAIL);
        statusDto.setMessage("导入成功！");

        if (ruleCode == null) {
            statusDto.setMessage("规则编码不能能为空！");
            return statusDto;
        }

        CentRule rule = centRuleService.getByCode(ruleCode);
        if (rule == null) {
            statusDto.setMessage("规则编码不存在！");
            return statusDto;
        }

        List<Cents> centList = new ArrayList();
        List<String> isHashCode = new ArrayList();

        int countCent = 0;

        for (int i = 0; i < dataList.size(); i++) {
            Cents cent = validateCentImport(i, dataList.get(i), statusDto, isHashCode, rule);
            if (cent == null)
                return statusDto;
            centList.add(cent);
            countCent += cent.getBalance();
        }

        Date date = new Date();
        CentApply apply = new CentApply();
        apply.setCreateTime(date);
        apply.setOperateTime(date);
        apply.setRuleCode(ruleCode);
        apply.setType(Type.IMPORT);
        apply.setUser(new AdminUser(userid));
        apply.setTotalCent(countCent);
        apply.setTotalRecord(centList.size());

        entityDao.insertCentApply(apply);

        for (Cents c : centList) {
            c.setApplyId(apply.getId());
            centsDao.insert(c);
        }

        return statusDto.buildDataSuccessStatusDto();
    }

    @Override
    public StatusDto manualAddUserCent(String ruleCode, String username, Integer cent, java.util.Date expireDate, Long loggedUserId) {

        CentApply apply = new CentApply();
        apply.setType(Type.ADD);
        apply.setRuleCode(ruleCode);
        apply.setUser(new AdminUser(loggedUserId));
        apply.setTotalCent(cent);
        apply.setTotalRecord(1);
        apply.setOperateTime(new java.util.Date());
        //插入申请并返回id
        this.entityDao.insertCentApply(apply);

        Cents cents = new Cents();
        cents.setApplyId(apply.getId());
        cents.setBalance(cent);
        cents.setCent(cent);
        cents.setRuleCode(ruleCode);
        CentRule centRule = new CentRule();
        centRule.setCode(ruleCode);
        cents.setCode(this.codeGenerator.generateCentCode(centRule));
        cents.setEffectiveDate(new Date());
        cents.setExpireDate(expireDate);
        cents.setUser(this.userService.getUserByUsername(username));
        cents.setStatus(Status.CANUSE);

        this.centsDao.insert(cents);
        return StatusDto.buildSuccessStatusDto("积分发放成功");
    }


    /**
     * 积分导入校验
     *
     * @param rowindex        行号
     * @param centApplyDetail 积分详细
     * @param statusDto       返回状态对象
     * @param centCodeMap     重复MAP
     * @return
     */
    private Cents validateCentImport(Integer rowindex, CentsImportExcelDto dto,
                                     StatusDto statusDto, List<String> isHasCode, CentRule rule) {
        Cents cents = new Cents();
        // 手机号、唯一识别码、积分值全部不能为空
        if (StringUtils.isEmpty(dto.getPhone())) {
            statusDto.setMessage("导入失败! 第" + (rowindex + 1) + "行"
                    + ": 手机号不可为空!");
            return null;
        }

        User user = userService.getByMobile(dto.getPhone());
        if (user == null) {
            statusDto.setMessage("导入失败! 第" + (rowindex + 1) + "行"
                    + ": 手机号不可用!");
            return null;
        }


        if (StringUtils.isEmpty(dto.getCentCode())) {
            statusDto.setMessage("导入失败! 第" + (rowindex + 1) + "行"
                    + ": 积分编码不可为空!");
            return null;
        }

        if (isHasCode.contains(dto.getCentCode())) {
            statusDto.setMessage("导入失败! 第" + (rowindex + 1) + "行"
                    + ": 积分编码不能重复导入!");
            return null;
        } else {
            isHasCode.add(dto.getCentCode());
        }

        Cents cent = centsDao.getByCode(dto.getCentCode());
        if (cent != null) {
            statusDto.setMessage("导入失败! 第" + (rowindex + 1) + "行"
                    + ": 积分编码已存在!");
            return null;
        }

        Integer value = -1;
        try {
            value = Integer.valueOf(dto.getCent());
        } catch (Exception e) {
            statusDto.setMessage("导入失败! 第" + (rowindex + 1) + "行"
                    + ": 积分必须为数字!");
            return null;
        }

        if (value < 0 || value > 99999) {
            statusDto.setMessage("导入失败! 第" + (rowindex + 1) + "行"
                    + ": 积分值必须是大于0的整数，最大不能超过99999!");
            return null;
        }

        cents.setCode(dto.getCentCode());
        cents.setCent(value);
        cents.setBalance(value);
        cents.setEffectiveDate(rule.getEffectiveDate());
        cents.setExpireDate(new Date());
        cents.setStatus(Status.CANUSE);
        cents.setRuleCode(rule.getCode());
        cents.setUser(user);
        cents.setDateline(new Date());
        cents.setCreateTime(new Date());

        return cents;
    }

    /**
     * 取得CELL值
     *
     * @param cell
     * @return
     */
    private static String getValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == Cell.CELL_TYPE_BOOLEAN) {
            boolean val = cell.getBooleanCellValue();
            return String.valueOf(val);
        } else if (cell.getCellType() == Cell.CELL_TYPE_NUMERIC) {
            double val = cell.getNumericCellValue();
            return String.format("%.0f", val);
        } else {
            return StringUtils.trimToEmpty(cell.getStringCellValue());
        }
    }

	@Override
	public Page<CentApply> searchScrollAddPage(Map<String, Object> params,
			Pageable pageable) {
		params.put(Constants.PAGE_OFFSET, pageable.getPageNumber());
		params.put(Constants.PAGE_SIZE, pageable.getPageSize());
		params.put(Constants.PAGE_SORT, pageable.getSort());

		List<CentApply> pageData = Collections.emptyList();
		Long count = this.entityDao.searchAddTotal(params);
		if (count > 0) {
			pageData = entityDao.searchAdd(params);
		}
		return new PageImpl<CentApply>(pageData, pageable, count);
	}

}
