package com.rocoinfo.rocomall.service.impl.cfg;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.cent.CentRule;
import com.rocoinfo.rocomall.entity.cfg.SigninRecord;
import com.rocoinfo.rocomall.entity.cfg.SigninRuleCfg;
import com.rocoinfo.rocomall.entity.cfg.SigninRuleCfg.CentCfgItem;
import com.rocoinfo.rocomall.repository.cfg.SigninRecordDao;
import com.rocoinfo.rocomall.service.cent.ICentRuleService;
import com.rocoinfo.rocomall.service.cfg.ISigninRecordService;
import com.rocoinfo.rocomall.service.cfg.ISigninRuleCfgService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <dl>
 * <dd>描述: 签到记录 Service</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年12月15日 下午2:47:44</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
@Service
@SuppressWarnings("unchecked")
public class SigninRecordService extends CrudService<SigninRecordDao, SigninRecord> implements ISigninRecordService {

	@Autowired
	private ISigninRuleCfgService signRuleService;
	@Autowired
	private ICentRuleService centRuleService;

	/**
	 * 获得用户最后一次签到记录
	 * 
	 * @param userId
	 */
	public SigninRecord getLastSignRecordByUserId(Long userId) {
		return this.entityDao.getLastSignRecordByUserId(userId);
	}

	@Transactional
	@Override
	public void insert(SigninRecord record) {
		super.insert(record);
		//给会员增加积分
		SigninRuleCfg signRule = signRuleService.getUniqueSigninRule();
		//连续第几天签到
		int signDays = record.getContinueSignDay() % signRule.getDayCycle();

		CentRule centRule = null;
		List<CentCfgItem> itemList = signRule.getCfgItemList();
		for (CentCfgItem item : itemList) {
			if (item.getDay() == signDays) {
				centRule = centRuleService.getById(item.getRule().getId());
				break;
			}
		}

		if (centRule.isUsable() && centRule.getCent() > 0) {
			//增加积分，FIXME TODO

		}
	}
}
