package com.rocoinfo.rocomall.service.impl.dict;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.dict.DictRankType;
import com.rocoinfo.rocomall.enumconst.Status;
import com.rocoinfo.rocomall.repository.dict.DictRankTypeDao;
import com.rocoinfo.rocomall.service.dict.IDictRankTypeService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class DictRankTypeService extends CrudService<DictRankTypeDao,DictRankType> implements IDictRankTypeService {

    public boolean isExistName(final String name) {
        if (StringUtils.isBlank(name)) {
            return false;
        }
        for (DictRankType rankType : findAll()) {
            if (rankType != null && rankType.getName().equalsIgnoreCase(name)) {
                return true;
            }
        }
        return false;
    }

    public void switchStatus(Long id, Status status) {
        DictRankType rankType = new DictRankType();
        rankType.setId(id);
        rankType.setStatus(status);
        this.update(rankType);
    }

    public List<DictRankType> findAllWithStatus(Status status){
        List<DictRankType> all = findAll();
        if (status==null){
            return all;
        }

        List<DictRankType> opens = new ArrayList<DictRankType>();
        List<DictRankType> locks = new ArrayList<DictRankType>();
        for (DictRankType rankType :all){
            if (rankType.getStatus()==Status.OPEN){
                opens.add(rankType);
            }else {
                locks.add(rankType);
            }
        }
        if (status ==Status.OPEN){
            return opens;
        }else{
            return locks;
        }
    }

}
