package com.rocoinfo.rocomall.service.impl.dict.express;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.dict.express.ExpressFeeItem;
import com.rocoinfo.rocomall.entity.dict.express.FeeItemCity;
import com.rocoinfo.rocomall.repository.dict.express.ExpressFeeItemDao;
import com.rocoinfo.rocomall.service.dict.express.IExpressFeeItemService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springside.modules.utils.Collections3;

import java.util.List;

/**
 * <dl>
 * <dd>描述:快递费用计算模板Item Service</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年11月26日 下午12:27:28</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
@SuppressWarnings("unchecked")
@Service
public class ExpressFeeItemService extends CrudService<ExpressFeeItemDao, ExpressFeeItem> implements IExpressFeeItemService {

	@Transactional(isolation = Isolation.READ_COMMITTED)
	@Override
	public void insert(ExpressFeeItem feeItem) {
		if (feeItem != null) {
			super.insert(feeItem);
			if (CollectionUtils.isNotEmpty(feeItem.getItemCitys())) {
				for (FeeItemCity itemCity : feeItem.getItemCitys()) {
					itemCity.setFeeItemId(feeItem.getId());
				}

				this.entityDao.saveItemCitys(feeItem.getItemCitys());
			}
		}
	}

	@Transactional(isolation = Isolation.READ_COMMITTED)
	public void deleteFeeItemsByTemplateId(long templateId) {
		if (templateId > 0) {
			List<ExpressFeeItem> itemList = this.entityDao.findItemsByTemplateId(templateId);
			if (CollectionUtils.isNotEmpty(itemList)) {
				this.entityDao.deleteItemsByTemplateId(templateId);
				List<Long> itemIdList = Collections3.extractToList(itemList, IdEntity.ID_FIELD_NAME);
				this.entityDao.deleteItemCitysByItemIds(itemIdList);
			}
		}
	}

	/**
	 * 通过快递公司Id和城市Id获得运费计算项
	 * 
	 * @param cityId
	 * @param expressId
	 */
	public ExpressFeeItem getFeeItemByCityIdAndExpressId(Long cityId, Long expressId) {
		return this.entityDao.getFeeItemByCityIdAndExpressId(cityId, expressId);
	}
}
