package com.rocoinfo.rocomall.service.impl.product;

import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.Brand;
import com.rocoinfo.rocomall.repository.BrandDao;
import com.rocoinfo.rocomall.service.IUploadService;
import com.rocoinfo.rocomall.service.product.IBrandService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SuppressWarnings("all")
@Service
public class BrandService extends CrudService<BrandDao, Brand> implements IBrandService {

	@Autowired
	private IUploadService uploadService;

	@Transactional(isolation = Isolation.READ_COMMITTED, readOnly = true)
	public Page<Brand> findBrandByPage(Map<String, Object> params, Pageable pageable) {
		if (params == null) {
			params = new HashMap<String, Object>();
		}
		params.put(Constants.PAGE_OFFSET, pageable.getOffset());
		params.put(Constants.PAGE_SIZE, pageable.getPageSize());
		params.put(Constants.PAGE_SORT, pageable.getSort());

		List<Brand> pageData = entityDao.search(params);
		Long count = entityDao.searchTotal(params);

		Page<Brand> page = new PageImpl<Brand>(pageData, pageable, count);
		return page;
	}

	@Override
	public void insert(Brand brand) {
		if (StringUtils.isNotBlank(brand.getImagePath())) {
			brand.setImagePath(uploadService.submitPath(brand.getImagePath()));
		}
		super.insert(brand);
	}

	@Override
	public void update(Brand brand) {
		// 删除旧图片文件，保存新图片文件
		Brand oldBrand = this.getById(brand.getId());
		if (brand == null || oldBrand == null) {
			throw new ServiceException("品牌对象为空,无法更新");
		}
		if (brand.getImagePath() != null) {
			if (StringUtils.isNotBlank(brand.getImagePath())) {
				brand.setImagePath(uploadService.updateFile(brand.getImagePath(), oldBrand.getImagePath()));
			}
		}
		super.update(brand);
	}
}
