package com.rocoinfo.rocomall.service.impl.product;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.ProdStockApply;
import com.rocoinfo.rocomall.entity.ProdStockApplyItem;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.StockApprove;
import com.rocoinfo.rocomall.entity.cent.Apply;
import com.rocoinfo.rocomall.entity.cent.Approve;
import com.rocoinfo.rocomall.repository.ProdStockApplyDao;
import com.rocoinfo.rocomall.repository.ProdStockApplyItemDao;
import com.rocoinfo.rocomall.repository.ProdStockApproveDao;
import com.rocoinfo.rocomall.service.IAdminUserService;
import com.rocoinfo.rocomall.service.product.IProdStockApplyService;
import com.rocoinfo.rocomall.service.product.ISkuService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <dl>
 * <dd>描述: 商品出入库管理Service</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年9月1日 下午17:22:40</dd>
 * <dd>创建人：huyt</dd>
 * </dl>
 */
@Service
@Transactional(isolation = Isolation.REPEATABLE_READ)
public class ProdStockApplyService extends CrudService<ProdStockApplyDao, ProdStockApply> implements IProdStockApplyService {

	@Autowired
	private ISkuService skuService;

	@Autowired
	private ProdStockApplyItemDao prodStockApplyItemDao;

	@Autowired
	private ProdStockApproveDao prodStockApproveDao;

	@Autowired
	private IAdminUserService adminUserService;

	@Override
	public StatusDto addOrUpdateStockApply(ProdStockApply prodStockApply, boolean checkFlag) {

		if (checkFlag) {
			for (ProdStockApplyItem itemInfo : prodStockApply.getProdStockApplyItems()) {
				Sku sku = this.skuService.getById(itemInfo.getProd().getId());

				// 定位库存种类
				int stockQuantity = 0;
				if (ProdStockApply.WareHouse.GOOD.equals(prodStockApply.getWarehouse())) {
					// 良品库
					stockQuantity = sku.getStock().intValue();
				} else {
					// 虚拟库
					stockQuantity = sku.getVirtualStock().intValue();
				}

				if (itemInfo.getQuantity() > stockQuantity) {
					return StatusDto.buildFailureStatusDto("商品： " + sku.getName() + "库存不足。 实际库存： " + sku.getStock().toString() + "件");
				}
			}
		}

		if (prodStockApply.getId() != null) {
			// 草稿提交
			// 出入库申请清单表清除
			prodStockApplyItemDao.deleteByApplyId(prodStockApply.getId());
			// 出入库存申请表更新
			this.update(prodStockApply);
		} else {
			// 直接保存/提交
			// 出入库存申请表登录
			this.insert(prodStockApply);
		}

		// 出入库申请清单表登录
		for (ProdStockApplyItem applyItem : prodStockApply.getProdStockApplyItems()) {
			applyItem.setApplyId(prodStockApply.getId());
			prodStockApplyItemDao.insert(applyItem);
		}

		return StatusDto.buildSuccessStatusDto("操作成功!");
	}

	@Override
	public StatusDto auditStockAppoly(StockApprove approve, Approve.ApproveResult result) {

		ProdStockApply prodStockApply = approve.getApply();

		//如果审批通过并且是出库 那么需要减少相应的库存
		if (Approve.ApproveResult.AGREE.equals(result)) {
			if (ProdStockApply.StockType.OUT.equals(prodStockApply.getType())) {
				for (ProdStockApplyItem item : prodStockApply.getProdStockApplyItems()) {
					Sku sku = this.skuService.getById(item.getProd().getId());

					// 定位库存种类
					int stockQuantity = 0;
					if (ProdStockApply.WareHouse.GOOD.equals(prodStockApply.getWarehouse())) {
						// 良品库
						stockQuantity = sku.getStock().intValue();
					} else {
						// 虚拟库
						stockQuantity = sku.getVirtualStock().intValue();
					}

					if (item.getQuantity() > stockQuantity) {
						return StatusDto.buildFailureStatusDto("商品： " + sku.getName() + "库存不足。 实际库存： " + sku.getStock().toString() + "件");
					}
				}
			}

			approve.getApply().setProdStockApplyItems(this.prodStockApplyItemDao.getByApplyId(prodStockApply.getId()));

			// 减少或者增加商品库存
			//this.skuService.batchInOrOutStock(approve.getApply());
		}

		// 保存审批结果
		prodStockApproveDao.insert(approve);

		// 更新申请表状态
		ProdStockApply newApply = new ProdStockApply();
		newApply.setId(prodStockApply.getId());
		newApply.setState(this.judgeApplyState(result));
		this.update(newApply);

		return StatusDto.buildSuccessStatusDto();
	}

	/**
	 * 根据审批结果 判断申请单的状态 通过:PASS 不通过:FAILED 驳回: DRAFT
	 * 
	 * @param result
	 * @return
	 */
	private Apply.State judgeApplyState(Approve.ApproveResult result) {
		if (Approve.ApproveResult.AGREE.equals(result)) {
			return Apply.State.PASS;
		} else if (Approve.ApproveResult.DISAGREE.equals(result)) {
			return Apply.State.FAILED;
		} else if (Approve.ApproveResult.RETURN.equals(result)) {
			return Apply.State.DRAFT;
		}
		return null;
	}

	/**
	 * 覆写原来的getById,获取申请单的同时,需要查询出商品详情
	 * 
	 * @param id
	 * @return
	 */
	@Override
	public ProdStockApply getById(Long id) {
		// 入出库申请
		ProdStockApply prodStockApply = this.entityDao.getById(id);
		// 入出库申请清单
		List<ProdStockApplyItem> applyItemList = prodStockApplyItemDao.getByApplyId(prodStockApply.getId());
		for (ProdStockApplyItem info : applyItemList) {
			Sku sku = skuService.getById(info.getProd().getId());
			skuService.buildDetail(sku);
			info.setProd(sku);
		}
		prodStockApply.setProdStockApplyItems(applyItemList);

		// 审批列表
		List<StockApprove> approveList = prodStockApproveDao.getByApplyId(id);
		if (approveList.size() > 0) {
			for (StockApprove info : approveList) {
				info.setApprover(adminUserService.getById(info.getApprover().getId()));
			}
			prodStockApply.setStockApproveList(approveList);
		}

		return prodStockApply;
	}
}