package com.rocoinfo.rocomall.service.impl.product;

import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.dto.ProdSKUMeta;
import com.rocoinfo.rocomall.dto.ProdSKUMeta.MetaItem;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.SkuMeta;
import com.rocoinfo.rocomall.repository.SkuMetaDao;
import com.rocoinfo.rocomall.repository.dict.DictSkuMetaDao;
import com.rocoinfo.rocomall.service.product.ISkuMetaService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * SKU属性名称DAO Created by robin on 14-6-12. author yangxc
 */
@Service
public class SkuMetaService extends CrudService<SkuMetaDao, SkuMeta> implements ISkuMetaService {
	@Autowired
	private DictSkuMetaDao dictSkuMetaDao;

	public SkuMeta getByProductId(Long productId) {
		return entityDao.getByProductId(productId);
	}

	public SkuMeta getByProductIdAndDictMeta(Long productId) {
		SkuMeta meta = entityDao.getByProductId(productId);
		if (meta == null) {
			return null;
		}
		if (StringUtils.isNotBlank(meta.getAttribute1Name())) {
			meta.setDictSkuMeta1(dictSkuMetaDao.selectByName(meta.getAttribute1Name()));
		}
		if (StringUtils.isNotBlank(meta.getAttribute2Name())) {
			meta.setDictSkuMeta2(dictSkuMetaDao.selectByName(meta.getAttribute2Name()));
		}
		if (StringUtils.isNotBlank(meta.getAttribute3Name())) {
			meta.setDictSkuMeta3(dictSkuMetaDao.selectByName(meta.getAttribute3Name()));
		}
		return meta;
	}

	/**
	 * 返回产品可以 销售的 所有sku元数据信息
	 * 
	 * @param productId
	 *            产品Id
	 */
	public ProdSKUMeta getProdSkuMetas(Sku sku) {
		ProdSKUMeta skuMeta = new ProdSKUMeta();
		if (sku != null) {
			List<Map<String, String>> skuMetaValueList = entityDao.getProdSkuMetas(sku.getProduct().getId());

			if (!CollectionUtils.isEmpty(skuMetaValueList)) {
				String sku1Name = null;
				String sku2Name = null;
				String sku3Name = null;

				List<String> sku1ValueList = Lists.newArrayList();
				List<String> sku2ValueList = Lists.newArrayList();
				List<String> sku3ValueList = Lists.newArrayList();

				final String selectedSkuValue1 = StringUtils.trimToEmpty(sku.getAttribute1());
				final String selectedSkuValue2 = StringUtils.trimToEmpty(sku.getAttribute2());

				for (int i = 0, len = skuMetaValueList.size(); i < len; i++) {
					Map<String, String> rowItem = skuMetaValueList.get(i);
					if (i == 0) {
						sku1Name = StringUtils.trimToEmpty(rowItem.get("attribute1_name"));
						sku2Name = StringUtils.trimToEmpty(rowItem.get("attribute2_name"));
						sku3Name = StringUtils.trimToEmpty(rowItem.get("attribute3_name"));
					}

					String skuValue1 = StringUtils.trimToEmpty(rowItem.get("attribute1"));
					String skuValue2 = StringUtils.trimToEmpty(rowItem.get("attribute2"));
					String skuValue3 = StringUtils.trimToEmpty(rowItem.get("attribute3"));

					if (!skuValue1.isEmpty() && !sku1ValueList.contains(skuValue1)) {
						sku1ValueList.add(skuValue1);
					}

					if (!skuValue2.isEmpty() && skuValue1.equals(selectedSkuValue1) && !sku2ValueList.contains(skuValue2)) {
						sku2ValueList.add(skuValue2);
					}

					if (!skuValue3.isEmpty() && skuValue1.equals(selectedSkuValue1) && skuValue2.equals(selectedSkuValue2)
							&& !sku3ValueList.contains(skuValue3)) {
						sku3ValueList.add(skuValue3);
					}
				}

				if (StringUtils.isNotEmpty(sku1Name)) {
					skuMeta.setSku1(new MetaItem(sku1Name, sku1ValueList));
				}

				if (StringUtils.isNotEmpty(sku2Name)) {
					skuMeta.setSku2(new MetaItem(sku2Name, sku2ValueList));
				}

				if (StringUtils.isNotEmpty(sku3Name)) {
					skuMeta.setSku3(new MetaItem(sku3Name, sku3ValueList));
				}
			}
		}
		return skuMeta;
	}
}
