package com.rocoinfo.rocomall.service.order;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.order.InstoreOrder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

/**
 * <dl>
 * <dd>描述:入库单Service接口</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015/11/12 17:48</dd>
 * <dd>@author：huyt</dd>
 * </dl>
 */
public interface IInstoreOrderService extends IBaseService<InstoreOrder> {

	/**
	 * 搜索商品的入库记录
	 * 
	 * @param productId 产品Id
	 * @param pageable
	 */
	public Page<InstoreOrder> searchInstoreRecordsByProdId(Long productId, Pageable pageable);

	/**
	 * 退货入库单,确认收货
	 * 
	 * @param instoreOrder
	 */
	public void refundConfirmReceive(InstoreOrder instoreOrder);
}
