package com.rocoinfo.rocomall.service.order;


import com.rocoinfo.rocomall.entity.params.OrderParams;
import org.springframework.data.domain.PageRequest;

/**
 * <dl>
 * <dd>描述: order service接口</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：16/8/11 下午3:36</dd>
 * <dd>创建人： Kong</dd>
 * </dl>
 */
public interface INewOrderService {

    /**
     * 处理用户提交订单的流程
     * @param orderParams 订单参数实体对象
     * @return
     */
    Object createOrder(OrderParams orderParams);

    /**
     * 支付订单流程
     *
     * @param orderParams 订单参数实体对象
     * @return
     */
    Object payOrder(OrderParams orderParams);

    /**
     * 根据状态查询订单列表接口 
     * @param userId 用户Id
     * @param status 订单状态
     * @return
     */
	Object findOrderItemList(PageRequest pageable, Long userId, String status);

	/**
     * 查询订单详情
     * @param orderId 订单id
     * @return
     */
	Object details(Long orderId);

	 /**
     * 用户取消订单
     * @param orderId 订单id
     * @param cancelReason
     * @return
     */
	Object cancel(Long orderId, String cancelReason);

	/**
     * 用户删除支付完成的订单
     * @param orderId 订单id
     * @return
     */
	Object delete(Long orderId);

	/**
     * 用户关闭订单的接口
     * @param orderId 订单id
     * @return
     */
	Object remindShipments(Long orderId);

	  
    /**
     * 确认收货接口
     * @param orderId 订单id
     * @return
     */
	Object confirmDelivery(Long orderId);

}
