package com.rocoinfo.rocomall.service.product;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.ProdStockApply;
import com.rocoinfo.rocomall.entity.StockApprove;
import com.rocoinfo.rocomall.entity.cent.Approve;

/**
 * <dl>
 * <dd>描述: 商品出入库管理Service</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年9月1日 下午17:22:40</dd>
 * <dd>创建人：huyt</dd>
 * </dl>
 */
public interface IProdStockApplyService extends IBaseService<ProdStockApply> {

    /**
     * 添加或更新出入库申请
     *
     * @param prodStockApply
     * @param checkFlag      库存检查标志位,当为出库时需要检查库存
     * @return
     */
    StatusDto addOrUpdateStockApply(ProdStockApply prodStockApply, boolean checkFlag);

    /**
     * 审批申请单
     *
     * @param approve
     * @param result
     * @return
     */
    StatusDto auditStockAppoly(StockApprove approve, Approve.ApproveResult result);
}
