package com.rocoinfo.rocomall.utils;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.PropertyHolder;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.UnsupportedEncodingException;
import java.util.*;
import java.util.Map.Entry;

/**
 * @author zhangmin
 * 新华接口签名验证
 */
public final class SignValidationUtils {
	
	public static final String SIGN = "sign";
	public static final String SIGN_TYPE = "sign_type";

	private SignValidationUtils(){
	}
	
	  
	 /** 
     * 除去数组中的空值和签名参数
     * @param paramPairs 签名参数组
     * @return 去掉空值与签名参数后的新签名参数组
     */
    private static Map<String,String> paramFilter(Map<String, String> paramPairs) {
    	if(paramPairs == null)
    		return paramPairs;

		return Maps.filterEntries(paramPairs, new Predicate<Entry<String, String>>(){

			@Override
			public boolean apply(Entry<String, String> input) {
				String key  = input.getKey();
				String value = input.getValue();
				
				if(StringUtils.isBlank(value)){
					return false;
				}
				
				if(SIGN.equalsIgnoreCase(key) || SIGN_TYPE.equalsIgnoreCase(key)) {
					return false;
				}
				return true;
			}
			
        });
	
    }
	
	
	/**
	 * 把数组所有元素排序，并按照“参数=参数值”的模式用“&”字符拼接成字符串
	 * @param paramPairs 需要排序并参与字符拼接的参数组
	 * @return 拼接后字符串
	 */
	public static String createLinkString(Map<String, String> paramPairs){ 
		if(MapUtils.isEmpty(paramPairs)) 
			return StringUtils.EMPTY;
		
		Map<String, String> sParaNew = paramFilter(paramPairs);
		List<String> keys = new ArrayList<String>(sParaNew.keySet());
		Collections.sort(keys);
		final String eq = "=";
		StringBuilder  sb  = new StringBuilder();
		for (int i = 0; i < keys.size(); i++) {
			String key = keys.get(i);
			String value = sParaNew.get(key);
			if (i == keys.size() - 1) {// 拼接时，不包括最后一个&字符
				sb.append(key).append(eq).append(value);
			} else {
				sb.append(key).append(eq).append(value).append("&");
			}
		}
		return sb.toString();
	}
	
	 
	
	public static String md5Sign(String linkString){
		String needSignLink = linkString + PropertyHolder.getApiKey();
		try {
			return DigestUtils.md5Hex(needSignLink.getBytes(Constants.DEFAULT_ENCODING));
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
			return StringUtils.EMPTY;
		}
	}
	
	public static String md5Sign(Map<String, String> paramPairs){
		return md5Sign(createLinkString(paramPairs));
	}
	

	public static boolean verifySign(Map<String, String> paramPairs, String signature){
		String mySign = md5Sign(paramPairs);
		return mySign.equals(signature);
	}
	
	 
	public static boolean verifySign(String myMd5Sign, String signature){
		return myMd5Sign.equals(signature);
	}
	
	/**
	 * 账户绑定时 校验签名
	 */
	public static boolean verifyBindSign(String platformCode,String ouid,String signature){
		Map<String, String> bindParamMap = new HashMap<String, String>();
		bindParamMap.put("platformCode", platformCode);
		bindParamMap.put("ouid", ouid);
		return verifySign(bindParamMap,signature);
	}
	
}