drop table if exists prod_product;
drop table if exists prod_catalog;
drop table if exists prod_product_catalog;
drop table if exists prod_brand;
drop table if exists prod_description;
drop table if exists prod_sku_meta;
drop table if exists prod_sku;
drop table if exists prod_price_history;
drop table if exists prod_product_image;
drop table if exists prod_review;
drop table if exists supplier;
drop table if exists acct_role;
drop table if exists acct_user;
drop table if exists acct_user_role;
drop table if exists acct_address;
drop table if exists sequence;
drop table if exists sales_order;
drop table if exists sales_order_item;
drop table if exists cart_item;
drop table if exists consult_thread;
drop table if exists consult_post;
drop table if exists activity;
drop table if exists activity_sku;
drop table if exists activity_record;
drop table if exists activity_record_cents;
drop table if exists auction_activity_record;
drop table if exists auction_refund_record;
drop table if exists banner_adv;
drop table if exists dict_prov_city;
drop table if exists system_message;
drop table if exists activity_focus;
drop table if exists prod_sepecial;
drop table if exists attention;
drop table if exists user_catalog_relation;
drop table if exists admin_log;
drop table if exists options;
drop table if exists acct_role_permission;
drop table IF exists acct_user_supplier;
drop table IF exists acct_login_log;
drop table IF exists dict_plan;
DROP TABLE IF EXISTS dict_system_settings;
DROP TABLE IF EXISTS activity_paintedegg_record;
DROP TABLE IF EXISTS sms_send_info;
DROP TABLE IF EXISTS acct_user_apply;
DROP TABLE IF EXISTS bank_pay_log;


CREATE TABLE sms_send_info (
  id int(11) NOT NULL AUTO_INCREMENT,
  tel_phone varchar(11) DEFAULT NULL COMMENT '手机号',
  user_id bigint(20) DEFAULT NULL COMMENT '用户id',
  sms_content varchar(500) DEFAULT NULL COMMENT '短信内容',
  send_status tinyint(1) DEFAULT NULL COMMENT '发送状态0失败1成功',
  create_time datetime DEFAULT NULL COMMENT '发送时间',
  PRIMARY KEY (id),
  KEY send_vs_code_tel_phone_index (tel_phone) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8


create table prod_product(
  id int not null auto_increment,
  name varchar(200),
  display_name varchar(200) DEFAULT NULL,
  brand_id int not null,
  promotion_word varchar(500),
  supplier_id int not null,
  list_time datetime comment '定时上架时间',
  delist_time datetime comment '定时下架时间', 
  status varchar(32),
  show_status varchar(32),
  is_visual tinyint(1) not null comment '是否是虚拟商品',  
 -- sale_invoice_id int COMMENT '发票类型', 
  key_world varchar(200)  ,
  is_display_inlist  tinyint(1) not null  comment '(是否在列表页中显示)sku中逻辑判断得到' ,
  cash_amt decimal(9,2) unsigned NOT NULL DEFAULT '0' COMMENT '现金价值',
  cent decimal(9,2) unsigned   NOT NULL DEFAULT '0' COMMENT '积分价值',
  merge_cash_amt decimal(9,2) unsigned   NOT NULL DEFAULT '0' COMMENT '现金加积分的现金价格',
  merge_cent decimal(9,2) unsigned   NOT NULL DEFAULT '0' COMMENT '现金加积分的积分价格',
  primary key (id)
) engine=InnoDB;

alter table prod_product AUTO_INCREMENT=1000001;

create table prod_catalog (
  id int not null auto_increment,
  parent_id int,
  name varchar(200),
  code varchar(200),
  display_order int,
  status varchar(32),
  img_url varchar(300) DEFAULT NULL,
  CONSTRAINT cname_unique unique(name),
  primary key (id)
) engine=InnoDB;


create table prod_product_catalog (
  product_id int,
  catalog_id int,
  primary key (product_id, catalog_id)
); 


create table prod_brand (
  id int not null auto_increment,
  name varchar(200),
  english_name varchar(200),
  image_path varchar(64),
  display_order int,
  is_used  tinyint(1) not null  comment '是否启用' ,
  primary key (id),
  CONSTRAINT brand_name_unique unique(name),
) engine=InnoDB;

create table prod_description (
  product_id int,
  introduction longtext,
  specification longtext,
  packing_list longtext,
  after_sale longtext,
  primary key (product_id)
) engine=InnoDB;

create table prod_sku_meta (
  product_id int,
  attribute1_name varchar(36),
  attribute2_name varchar(36),
  attribute3_name varchar(36),
  primary key (product_id)
) engine=InnoDB;

create table prod_sku (
  id int not null auto_increment,
  code varchar(64) not null,
  name varchar(200),
  product_id int,
  attribute1 varchar(36),
  attribute2 varchar(36),
  attribute3 varchar(36),
  stock int not null default 0 COMMENT '良品库存',
  defect_stock int not null default 0 COMMENT '残次品库存',
  virtual_stock int not null  default 0,
  occupied_stock int default 0 COMMENT '占用库存',
  warning_stock int default 0,
  status varchar(32) not null COMMENT '启用、关闭',
  is_display_inlist  tinyint(1) not null  comment ' 是否在列表页中显示 ' ,
  supplier_prod_code varchar(30) DEFAULT NULL COMMENT '供应商商品编码',
  cash_amt decimal(9,2) unsigned   NOT NULL DEFAULT '0' COMMENT '现金价值',
  cent decimal(9,2) unsigned   NOT NULL DEFAULT '0' COMMENT '积分价值',
  merge_cash_amt decimal(9,2) unsigned   NOT NULL DEFAULT '0' COMMENT '现金加积分的现金价格',
  merge_cent decimal(9,2) unsigned   NOT NULL DEFAULT '0' COMMENT '现金加积分的积分价格',
  orig_cash_amt decimal(9,2) unsigned   NOT NULL DEFAULT '0' COMMENT '原现金价值',
  orig_cent decimal(9,2) unsigned   NOT NULL DEFAULT '0' COMMENT '原积分价值',
  orig_merge_cash_amt decimal(9,2) unsigned   NOT NULL DEFAULT '0' COMMENT '原现金加积分的现金价格',
  orig_merge_cent decimal(9,2) unsigned   NOT NULL DEFAULT '0' COMMENT '原现金加积分的积分价格',
  primary key (id),
  CONSTRAINT sku_unique UNIQUE (product_id,attribute1,attribute2,attribute3),
  CONSTRAINT code_unique UNIQUE (code)
) engine=InnoDB;
alter table prod_sku AUTO_INCREMENT=10000001;

create table prod_price_history (
  id bigint primary key auto_increment,
  sku_id bigint,
  cash_amt decimal(9,2) unsigned   NOT NULL DEFAULT '0' COMMENT '现金价值',
  cash decimal(9,2) unsigned   NOT NULL DEFAULT '0' COMMENT '积分价值',
  merge_cash_amt decimal(9,2) unsigned   NOT NULL DEFAULT '0' COMMENT '现金加积分的现金价格',
  merge_cent decimal(9,2) unsigned   NOT NULL DEFAULT '0' COMMENT '现金加积分的积分价格',
  user_id bigint,
  time datetime
) engine=InnoDB;

-- 出入库存申请表
create table prod_stock_apply(
  id int primary key auto_increment,
  apply_code varchar(20) not null comment '申请单号',
  opertype varchar(20) not null comment '操作类型：in(入库),out(出库)',
  warehouse varchar(20) not null comment '良品库、虚拟库、残次品库',
  is_visual tinyint(1)  not null comment '是否是虚拟商品  1:虚拟商品出入库   0:实物商品出入库',
  user_id int not null comment '出、入库申请人',
  state varchar(10) not null comment '申请状态：草稿、待审批、审批通过、审批不通过',
  note varchar(200) comment'出入库的说明',
  apply_date datetime not null comment '出/入库申请提交时间',
  UNIQUE KEY uqk_stock_applycode (apply_code)
)engine=InnoDB;

-- 出入库申请 清单 
create table prod_stock_apply_item(
   id int primary key auto_increment,
   apply_id int not null comment '申请Id',
   sku_id int not null,
   quantity int not null comment '出入库数量',
   UNIQUE KEY uqk_applyid_skuid(apply_id,sku_id)
)engine=InnoDB;

-- 出入库申请 审批表
create table prod_stock_approve(
  id int primary key auto_increment,
  apply_id int not null comment '申请Id',
  approver int not null comment '审批人',
  result varchar(20) not null comment '审批结果:pass,failed,return',
  note varchar(200) comment'审批说明（拒绝理由）',
  audit_date datetime not null comment '审批时间'
)engine=InnoDB;

CREATE INDEX idx_stockapprove_applyid ON prod_stock_approve (apply_id);

create table prod_product_image (
  id int not null auto_increment,
  product_id int,
  sku_id int,
  path varchar(200),
  display_order int,
  imageType varchar(32),
  primary key (id)
) engine=InnoDB;

create table prod_review(
  id int primary key auto_increment,
  sku_id int not null,
  order_id int not null,
  user_id int not null,
  score int  not null default 0,
  product_score int not null default 0,
  custom_service_score int not null default 0,
  delivery_score int  not null default 0,
  content varchar(300),
  create_time datetime,
  unique(user_id,order_id,sku_id)
) engine=InnoDB;

create table supplier (
  id int not null auto_increment,
  code varchar(30) not null,
  name varchar(200) not null,
  short_name varchar(20),
  display_order int,
  useable tinyint(1) not null  default 1,
  primary key (id),
  UNIQUE KEY uqk_supplyer_name(name),
  UNIQUE KEY uqk_supplyer_code(code)
) engine=InnoDB;


create table acct_user_role (
  user_id bigint not null,
  role_id bigint not null,
  primary key (user_id, role_id)
) engine=InnoDB;

create table acct_role (
  id bigint auto_increment,
  name varchar(255) not null unique,
  primary key (id)
) engine=InnoDB;

create table acct_role_permission (
  role_id bigint,
  permission varchar(255),
  primary key (role_id, permission)
) engine=InnoDB;

--用户信息表 
create table acct_user(
  id bigint auto_increment,
  login_name varchar(255) unique COMMENT '用户名',
  name varchar(64),
  password varchar(255),
  salt varchar(64),
  mobile_phone varchar (40) COMMENT '绑定的手机号',
  email varchar(128),
  email_verify varchar(10) COMMENT'邮箱是否验证',
  is_member tinyint(1) not null COMMENT '1=>会员账户,  0=>后台管理账号',
  status varchar(20) not  null COMMENT '启用、禁用',
  growth int(11) not null default 0 COMMENT'成长值,用来确定会员等级,一直向上累积',
  profile_image varchar(256),
  register_date timestamp not null,
  birthday date,
  gender   varchar(10),
  pay_password varchar(100),
  pay_password_salt varchar(64),
  sso_username varchar(255) unique,
  inviteCode varchar(10) null COMMENT '自己生成的邀请码',
  inviteUserCode varchar(10) null COMMENT '注册所使用的邀请码',
  UNIQUE KEY uqk_user_mobile (mobile_phone),
  primary key (id)
) engine=InnoDB;

alter table acct_user AUTO_INCREMENT=10000001;

-- 用户等级
create table acct_user_level(
   id int primary key auto_increment,
   level varchar(20) not null  COMMENT '会员等级,如砖石卡、金卡、银卡',
   cent int(11) not null COMMENT  '到达该等级需要的积分',
   discount decimal(5,2) not null COMMENT '该等级的会员享受的折扣',
   img_url varchar(100) not null  COMMENT '会员图标',
   note varchar(200) COMMENT '备注',
   UNIQUE KEY uqk_acc_level (level) ,
   UNIQUE KEY uqk_acc_level_cent (cent)
)engine=InnoDB;

-- 用户与其它系统绑定关系表
create table acct_user_bind(
   user_id int(11) not null,
   plat_id int(11) not null COMMENT '其他系统平台Id',
   ouid varchar(50) not null COMMENT  '其他平台系统用户Id',
   UNIQUE KEY uqk_user_bind (user_id,plat_id,ouid)
)engine=InnoDB;


CREATE TABLE acct_login_log (
   id int(11) PRIMARY KEY AUTO_INCREMENT,
   user_id int(11) DEFAULT NULL,
   ip varchar(32) DEFAULT NULL,
   login_time datetime not null
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE INDEX idx_loginlog_usrid ON acct_login_log (user_id);

-- 积分表
create table cents(
   id int primary key auto_increment,
   code varchar(20) not null COMMENT '积分唯一编码',
   cent int(11) not null COMMENT '积分值',
   balance int(11) not null COMMENT '余额',
   effective_date date COMMENT '生效日',
   expire_date date not null COMMENT '有效截止日',
   status varchar(20) not null COMMENT '积分状态：可用、已使用、已失效，锁定',
   plan_code varchar(20) not null COMMENT '计划编码',
   rule_code varchar(20) not null COMMENT '积分规则编码',
   plat_code varchar(20) not null  COMMENT '来源平台系统编码',
   user_id int(11),
   ouid varchar(50) COMMENT  '其他平台系统用户Id',
   dateline timestamp not null,
   UNIQUE KEY uqk_cent_code (code)
)engine=InnoDB;

CREATE INDEX idx_cents_usrid ON cents (user_id);

-- 积分消耗记录 
create table cent_consume_record(
  id int primary key auto_increment,
  snum varchar(30) not null COMMENT '交易流水号',
  consume_type_code varchar(20) not null COMMENT '消耗类型code reference dict_cent_consume_type(code)',
  pay_platcode varchar(20) not null COMMENT '积分消耗支付平台',
  consume_cent int not null COMMENT '消耗积分值',
  user_id int not null COMMENT '消耗积分人',
  entity_id int COMMENT '积分消费实体Id,例如：订单Id',
  status varchar(10) not null COMMENT '消耗状态，消耗 还是 已返分',
  dateline datetime not null,
  UNIQUE KEY uqk_consume_snum(snum)
)engine=InnoDB;

CREATE INDEX idx_consume_usrid ON cent_consume_record (user_id);


-- 积分消耗流水表
create table cent_consume_detail(
  id int primary key auto_increment,
  consume_record_id int not null COMMENT '积分规则编码 reference cent_consume_record(id)',
  cent_id int not null COMMENT '积分Id reference cents(id)',
  cent int not null COMMENT '用此积分卡 消耗的积分值',
  refund_cent int not null default 0 COMMENT '已返积分'
)engine=InnoDB;

CREATE INDEX idx_consume_record_id ON cent_consume_detail (consume_record_id);


-- 积分申请
create table cent_apply(
   id int primary key auto_increment,
   code varchar(20) not null COMMENT '申请编号',
   type varchar(10) not null COMMENT'申请类型：如：导入申请、加分申请、减分申请',
   applyer int not null  COMMENT '填写申请人',
   approver int not null COMMENT '指定的审批人',
   state varchar(10) not null comment '申请状态：待审批、审批通过、审批不通过',
   note varchar(200) COMMENT '申请事由',
   apply_date datetime not null comment '申请提交时间',
   UNIQUE KEY uqk_cent_apply_code(code)
)engine=InnoDB;

-- 积分申请 对应的 积分细目
create table cent_apply_detail(
  id int primary key auto_increment,
  apply_id int not null,
  cent_code varchar(20) not null COMMENT '积分编码',
  cent int not null COMMENT '积分值',
  user_id int not null COMMENT '积分所属人',
  effect_date date not null,
  expire_date date not null COMMENT '有效截止日期',
  plan_code varchar(20) not null COMMENT '计划编码',
  rule_code varchar(20) not null COMMENT '规则编码',
  plat_code varchar(20) not null  COMMENT '来源平台系统编码',
  UNIQUE KEY uqk_apply_cent_code (apply_id,cent_code)
)engine=InnoDB;

-- 积分审批
CREATE TABLE cent_approve (
  id int(11) NOT NULL AUTO_INCREMENT,
  apply_id int(11) NOT NULL,
  approver int(11) NOT NULL COMMENT '审批人',
  result varchar(10) NOT NULL COMMENT '审批结果：通过、不通过',
  notation varchar(200) DEFAULT NULL,
  approve_date datetime NOT NULL COMMENT '审批日期',
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE INDEX idx_centapprove_applyid ON cent_approve(apply_id);


create table acct_address(
  id int(11) NOT NULL AUTO_INCREMENT,
  user_id int(11) unsigned NOT NULL DEFAULT '0',
  prov_city_id int(11) unsigned NOT NULL DEFAULT '0' COMMENT '省、市、县 外键id',
  address varchar(1000) NOT NULL DEFAULT '' COMMENT '详细地址',
  recipient varchar(64) NOT NULL DEFAULT '' COMMENT '收货人名字',
  postcode varchar(10) DEFAULT NULL COMMENT '邮编',
  mobile varchar(20) not null default '' COMMENT '收货人手机',
  recipient_phone varchar(64) DEFAULT NULL COMMENT '收货人固定电话',
  is_default tinyint(1) not null default 0 COMMENT '是否是默认收货地址',
  visiable  tinyint(1) not null default 1 COMMENT'是否在前台显示',
  PRIMARY KEY (id)
) ENGINE=InnoDB;

CREATE INDEX idx_address_usrid ON acct_address(user_id);

CREATE TABLE sequence (
  id int(11) NOT NULL AUTO_INCREMENT,
  tab varchar(30) NOT NULL,
  start_val int(6) NOT NULL,
  incr_by int(6) NOT NULL,
  cur_val int(11) NOT NULL,
  PRIMARY KEY (id),
  UNIQUE KEY uqk_seq_table (tab)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

create table sales_order(
  id int auto_increment,
  order_code varchar(30) not null unique comment '总订单号',
  user_id int not null,
  create_time datetime not null,
  user_level_name varchar(20) comment '支付订单时用户的成长值级别', 
  delivery_time_preference varchar(20) comment '送货的时间(只节假日等)',
  note varchar(200) default null comment '客户下单留言',
  delivery_address_id int default null comment '配送地址ID',
  invoice_type varchar(10)  COMMENT 'NONE("不开发票"), PERSONAL("个人"), COMPANY("单位")',
  invoice_title varchar(100) comment ' 发票抬头 :例如公司名称',
  payment_type varchar(20) not null comment '结算方式:CASH("全现金"),CENT("全积分"),CASH_AND_CENT("积分+现金")',
  cash_pay_type varchar(20) comment '现金部分的支付方式：银联 、支付宝',
  cash_amt decimal(9,2) not null default 0 comment '订单中的商品使用现金',
  cent int not null default 0 comment '订单中的商品使用积分',
  deliver_fee decimal(9,2) not null default 0 comment '运费',
  trade_no varchar(50)  comment '第三方现金支付系统的交易号',
  trade_state varchar(10) comment '第三方现金支付系统交易状态',
  cash_payed tinyint(1) not null default 0 comment '现金部分是否支付成功',
  cent_payed tinyint(1) not null default 0 comment '积分部分是否支付成功',
  payed_time datetime comment '订单完成支付时间',
  primary key (id)
) engine=InnoDB;

CREATE INDEX idx_order_usrid ON sales_order(user_id);
CREATE INDEX idx_order_creatime ON sales_order (create_time);


create table sales_order_item(
  id int auto_increment,
  user_id int not null,      -- 冗余字段, 优化查询
  supplier_id int not null, 
  order_code varchar(30) not null unique comment '子订单号,套装商品中每个sku都生成一个子订单号',
  order_type varchar(20) not null comment '普通订单、团购订单、竞拍订单（各活动类型枚举值）', 
  sku_id int not null comment '单品id',
  activity_id int default null comment '活动id,如果购买的是活动商品则记录活动id,套装商品拆成多个order_item记录',
  quantity int(11) not null comment '购买数量',
  original_cent int(11) not null comment '原价积分', 
  cent  int not null comment '支付积分单价',
  price decimal (9, 2) not null comment '现金部分单价',
  status varchar(20) not null comment '已下单、已取消、已处理、配送中、已完成、退货中、已退货、换货中、已换货',
  order_id int not null comment '订单表主键',
  product_name varchar(200) comment '用户购买时的商品名称',
  create_time datetime not null,
  express_id int comment '快递公司id',
  transportno varchar(60) comment '运单号',
  sku_pro_price decimal(9,2) DEFAULT NULL COMMENT 'sku商品价',
  sku_ser_price decimal(9,2) DEFAULT NULL COMMENT 'sku服务价',
  primary key (id)
) engine=InnoDB;

CREATE INDEX idx_orderitem_usrid ON sales_order_item(user_id);
CREATE INDEX idx_orderitem_supplierid ON sales_order_item(supplier_id);
CREATE INDEX idx_orderitem_orderid ON sales_order_item(order_id);
CREATE INDEX idx_orderitem_creatime ON sales_order_item(create_time);


-- 子订单 状态操作日志
create table order_item_operlog(
 id int primary key  auto_increment,
 order_item_id int not null,
 operator_id int not null comment'操作人Id',
 operation varchar(20) not null comment '操作',
 note varchar(200) comment '操作说明备注',
 log_time datetime not null comment '操作时间'
)engine=InnoDB;

CREATE INDEX idx_orderitemlog_itemid ON order_item_operlog(order_item_id);


-- 购物车， 只有登录的用户才保存购物车,购物车提交生成订单后立即清除购物车,购物车包括可能包含两种类型的商品（普通商品和活动）
create table cart_item(
  id int primary key auto_increment,
  user_id int not null default 0 comment '所属用户Id  references acct_user(id)',
  unit_prod_id int not null default 0 comment '单品id',
  quantity int null default null comment '购买数量',
  checked  tinyint(1) not null default 0,
  unique(user_id,unit_prod_id)
) engine=InnoDB;

CREATE INDEX idx_cart_usrid ON cart_item(user_id);

create table consult_thread (
  id int not null auto_increment,
  user_id int not null comment '发出咨询的客户',
  content varchar(300) not null comment '咨询内容',
  create_time datetime comment '创建时间',
  sku_id int,
  product_id int,   -- 待删除
  status varchar(20),
  send_email int comment '是否发邮件',
  primary key (id)
) engine=InnoDB;

create table consult_post(
  id int not null auto_increment,
  user_id int not null,
  content varchar(300) not null comment '内容',
  create_time datetime comment '创建时间',
  consult_id int not null,
  type varchar(20),
  primary key (id)
) engine=InnoDB;

create table activity (
  id int not null auto_increment,
  name varchar(255) not null,
  promotion_word varchar(300),
  start_time datetime not null,
  end_time datetime,
  status varchar(20),
  only_actsale tinyint(1) not null default 0 comment'是否仅活动可以销售',
  type varchar(20),
  supplier_id int,
  join_cent int comment '活动参与所需积分',
  auct_incrmin int,    
  auct_incrmax int,   
  auct_initcent int,
  auct_topn int,
  seq int,
  primary key (id)
) engine=InnoDB;


create table activity_sku (
  id int auto_increment,
  activity_id int,
  sku_id int,
  cent int,
  hit_parameter int comment '中奖参数,必须是参与积分的整数倍',
  prize_num int comment '总奖品数量',  
  hit_num int comment '已中奖品数',
  count int,
  presale_delivery_time datetime,
  hide_presale_delivery_time tinyint(1),
  primary key (id)
) engine=InnoDB;

CREATE INDEX idx_actsku_skuid ON activity_sku (sku_id);
CREATE INDEX idx_actsku_actid ON activity_sku (activity_id);



CREATE TABLE activity_record (
  id int(11) NOT NULL AUTO_INCREMENT,
  activity_id int(11) NOT NULL,
  user_id int(11) NOT NULL,
  cent int(11) NOT NULL,
  hit_skuid int(11) COMMENT '命中skuId',
  join_time datetime NOT NULL COMMENT '参与活动时间',
  erase_time datetime DEFAULT NULL COMMENT '刮卡时间',
  status varchar(20) NOT NULL COMMENT '状态：中奖 hit 、未中奖 lost ,作废 expired',
  order_id varchar(20) COMMENT '订单号',
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE INDEX idx_actrecord_actid ON activity_record (activity_id);
CREATE INDEX idx_actrecord_usrid ON activity_record (user_id);

-- 参与竞拍活动记录表
CREATE TABLE auction_activity_record (
  id int(11) NOT NULL AUTO_INCREMENT,
  activity_id int(11) NOT NULL,
  user_id int(11) NOT NULL,
  new_cent int(11) NOT NULL COMMENT '最新出价',
  incr_cent int(11) NOT NULL COMMENT '新增出价',
  join_dateline datetime NOT NULL COMMENT '出价时间戳 （毫秒）',
  PRIMARY KEY (id)
) ENGINE=InnoDB ;

CREATE INDEX idx_auctrecord_actid ON auction_activity_record (activity_id);
CREATE INDEX idx_auctrecord_usrid ON auction_activity_record (user_id);

-- 竞拍活动返分记录
create table auction_refund_record(
  id int(11) NOT NULL AUTO_INCREMENT,
  act_id int(11) NOT NULL,
  user_id int(11) NOT NULL,
  cent int(11) NOT NULL COMMENT '返分数',
  status varchar(20) DEFAULT NULL COMMENT '退分状态：未知、成功、失败',
  hit_status varchar(20) DEFAULT NULL COMMENT '中奖状态：中奖,未中奖,已超时',
  PRIMARY KEY (id)
)engine=InnoDB;

CREATE INDEX idx_auctrefund_actid ON auction_refund_record (act_id);
CREATE INDEX idx_auctrefund_usrid ON auction_refund_record (user_id);
  

create table banner_adv(
  id int auto_increment,
  position varchar(40) not null comment '广告位置 大焦点图, 大焦点图下面的广告图，新品推荐广告图、最具人气广告图,促销专区广告图,手机端广告',
  title varchar(100) comment '广告标题/广告产品名称',
  adv_word varchar(100) comment '广告宣传语',
  img_source varchar(10) comment '图片来源, URL_INVOKE:地址调用;  UPLOAD:本地上传 ',
  img_url varchar(100) NOT NULL comment '图片地址 ',
  link_url varchar(150) NOT NULL comment '图片点击后跳转地址',
  display_order smallint NOT NULL comment '显示顺序',
  visible tinyint(1) not null default 1 comment'是否显示',
  bg_color varchar(20) comment '背景颜色值',
  primary key (id)
) engine=InnoDB;

create table dict_prov_city(
  id int not null primary key auto_increment,
  name varchar(100) not null comment '省/城/县 名',
  pid int not null default 0 comment '父id',
  deliver_fee decimal(9,2) comment '运费',
  free_limit_amt decimal(9,2) comment '免运费限额,即订单金额 >=此金额，则免运费,如果设置为0，则收运费',
  display_order int not null default 0,
  unique (pid,name)
) engine=InnoDB;

-- 新华系统平台 字典数据表
create table dict_platform(
  id int not null primary key auto_increment,
  code varchar(20) not null comment '平台编号',
  name varchar(100) not null comment '系统平台名称',
  bind_notify_url varchar(200) comment '新华其他平台账号在积分平台绑定成功后，异步通知新华地址',
  newchina_bind_url varchar(200) comment '跳转去新华的绑定地址',
  icon_path varchar(100) comment '系统平台名称',
  visiable tinyint(1) not null,
  UNIQUE KEY uqk_plat_code (code),
  UNIQUE KEY uqk_plat_name (name)
)engine=InnoDB;

-- 部门字典
create table dict_department(
  id int not null primary key auto_increment,
  code varchar(20) not null comment '部门编号',
  name varchar(100) not null comment '部门名称',
  UNIQUE KEY uqk_department_code (code),
  UNIQUE KEY uqk_department_name (name)
)engine=InnoDB;

-- 积分消耗类型 字段数据
create table dict_cent_consume_type(
  id int not null primary key auto_increment,
  code varchar(40) not null comment '积分消耗类型编码',
  name varchar(100) not null comment '积分消耗类型名称',
  UNIQUE KEY uqk_consumetype_code (code),
  UNIQUE KEY uqk_consumetype_name (name)
)engine=InnoDB;

-- 积分发放计划  即：积分发放通道，例如：签到、注册等
create table dict_plan(
  id int not null primary key auto_increment,
  code varchar(40) not null comment '计划编码，系统自动生成',
  plan_type tinyint(1) not null comment '计划类型： 1 手工加分, 2 手工导入积分, 3系统调用',
  name varchar(100) not null comment '发放计划名称',
  security_key varchar(100) not null comment'计划密钥',
  send_sms tinyint(1) not null comment'是否发送短信',
  status varchar(32) not null comment '状态：启用/禁用',
  start_date date not null comment '开始日期',
  end_date date not null comment '结束日期',
  UNIQUE KEY uqk_plan_code (code),
  UNIQUE KEY uqk_plan_name (name)
)engine=InnoDB;


-- 积分预算表
create table cent_budget(
  id int not null primary key auto_increment,
  code varchar(40) not null comment '预算编码，系统自动生成',
  name varchar(100) not null comment '预算项名称',
  dept_id int not null comment '部门id,references dict_department(id)',
  subject varchar(100) not null comment '预算财务科目',
  allocated_cent int not null default 0 comment '已分配预算',
  total_cent int not null default 0 comment '预算总积分',
  useable tinyint(1) not null default 1 comment '1启用、  0禁用',
  UNIQUE KEY uqk_budget_code (code),
  UNIQUE KEY uqk_budget_name (name)
)engine=InnoDB;

-- 积分规则表
create table cent_rule(
  id int not null primary key auto_increment,
  code varchar(40) not null comment '规则编码，系统根据约定规则进行系统生成',
  name varchar(100) not null comment '规则名称',
  note varchar(200) comment'规则说明',
  rule_exp varchar(100) not null comment '规则表达式',
  state tinyint(1) not null default 1 comment '1启用、  0禁用',
  UNIQUE KEY uqk_cent_rule_code (code),
  UNIQUE KEY uqk_cent_rule_name (name)
)engine=InnoDB;


-- 计划 规则 关联关系表
create table plan_rule(
  id int not  null primary key auto_increment,
  plan_id int not null comment'计划Id,references dict_plan(id)',
  rule_id int not null comment'规则Id,references cent_rule(id)',
  budget_id   int not null comment '预算Id references cent_budget(id)',
  budget_cent int not null comment '子预算额度',
  used_cent   int not null default 0 comment '子预算已经积分',
  start_date  date not null comment '子预算的 开始日期',
  end_date    date not null comment '子预算的结束日期',
  expire_way  varchar(20) not null comment'子预算通过此积分规则生成的积分，积分失效方式', 
  expire_date date  comment '指定的积分失效日期',
  delay_days  int comment '生效日期+延期的天数',
  can_use     tinyint(1) not null default 1 comment '1启用、  0禁用',
  UNIQUE KEY uqk_plan_rule(plan_id,rule_id)
)engine=InnoDB;


-- 快递公司 字段数据
create table dict_express(
  id int not null primary key auto_increment,
  code varchar(40) not null comment '快递公司编码',
  name varchar(100) not null comment '快递公司名称',
  home_url varchar(100) comment'快递公司官网',
  logistic_url varchar(100) comment'物流信息查询地址',
  status varchar(10) not null,
  UNIQUE KEY uqk_express_code (code),
  UNIQUE KEY uqk_express_name (name)
)engine=InnoDB;

create table dict_sku_meta (
  name varchar(36),
  display_name varchar(36),
  propertys varchar(1000),
 id int not null primary key auto_increment
) engine=InnoDB;

-- 系统消息
create table system_message(
  id int primary key auto_increment,
  content varchar(1000),
  user_id int not null,
  source varchar(20) comment '消息来源',
  status varchar(20) DEFAULT 'UNREAD',
  create_time datetime
) engine=InnoDB;

-- 首页焦点活动产品 例如：首页的 ”限时抢购活动“
create table activity_focus(
  id int auto_increment,
  act_type varchar(20),
  activity_id int,
  unique(act_type),
  primary key(id)
) engine=InnoDB;

-- 特殊位置展示的产品（包括：新品推荐、最具人气、尾品会等）
create table prod_sepecial(
  id int primary key auto_increment,
  type varchar(20) not null comment '新品推荐，最具人气，促销专区,分类推荐,热销排行,尾品会',
  catalog_id int not null default 0 comment '当type是分类推荐时，是分类Id',
  sku_id int not null default 0,
  display_order int not null default 0
)engine=InnoDB;

-- 关注
create table attention(
  id int primary key auto_increment,
  user_id int not null,
  sku_id int not null,
  unique(user_id,sku_id)
)engine=InnoDB;

-- 关注索引，用户查询关注列表
CREATE INDEX idx_attention_usrid ON attention (user_id);

-- 用户兴趣分类
create table user_catalog_relation(
  id int primary key auto_increment,
  user_id int not null,
  catalog_id int not null,
  unique(user_id,catalog_id)
)engine=InnoDB;

create table admin_log(
  id bigint primary key auto_increment,
  user_id int,
  object_type varchar(32),
  object_id int,
  action varchar(255),
  action_time datetime
)engine=InnoDB;

CREATE INDEX idx_admlog_objectid ON admin_log (object_id);
CREATE INDEX idx_admlog_usrid ON admin_log (user_id);

create table options (
  id bigint primary key auto_increment,
  name varchar(255) not null unique,
  value longtext
)engine=InnoDB;

CREATE TABLE acct_user_supplier (
  user_id bigint(20) NOT NULL,
  supplier_id bigint(20) NOT NULL,
  PRIMARY KEY (user_id,supplier_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE dict_system_settings (
  id bigint(20) NOT NULL AUTO_INCREMENT,
  key_name varchar(32) DEFAULT NULL COMMENT '设置对应key,做缓存',
  show_name varchar(32) DEFAULT NULL COMMENT '显示字段名',
  control_type varchar(16) DEFAULT NULL COMMENT '控件类型',
  key_value varchar(64) DEFAULT NULL COMMENT '对应的值',
  tips varchar(128) DEFAULT NULL COMMENT '提示信息',
  show_value varchar(128) DEFAULT NULL COMMENT '给控件的值',
  PRIMARY KEY (id)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;


CREATE TABLE activity_paintedegg_record (
  id int(11) NOT NULL AUTO_INCREMENT COMMENT 'id主键',
  user_id int(11) NOT NULL COMMENT '用户ID',
  egg_id varchar(32) NOT NULL DEFAULT '' COMMENT '彩蛋编号',
  create_time datetime NOT NULL COMMENT '找到彩蛋日期',
  PRIMARY KEY (id)
) ENGINE=InnoDB AUTO_INCREMENT=129 DEFAULT CHARSET=utf8;

-- 用户添加导入申请
create table acct_user_apply(
   id int primary key auto_increment,
   code varchar(20) not null COMMENT '申请编号',
   apply_type varchar(10) not null COMMENT'申请类型：如：会员导入 会员新增',
   applyer int not null  COMMENT '填写申请人',
   approver int not null COMMENT '指定的审批人',
   state varchar(10) not null comment '申请状态：待审批、审批通过、审批不通过',
   note varchar(200) COMMENT '申请事由',
   apply_date datetime not null comment '申请提交时间',
   apply_user_acct text NULL,
   UNIQUE KEY uqk_cent_apply_code(code)
)engine=InnoDB;


-- 积分归属类型 字段数据
create table dict_cent_consume_owner(
  id int not null primary key auto_increment,
  code varchar(40) not null comment '积分消耗类型编码',
  name varchar(100) not null comment '积分消耗类型名称',
  status varchar(10) not null,
  UNIQUE KEY uqk_consumetype_code (code),
  UNIQUE KEY uqk_consumetype_name (name)
)engine=InnoDB;

create table prod_temp(
  id int not null primary key auto_increment,
  user_id int, 
  json_String varchar(10000) not null comment '商品json串' 
)engine=InnoDB;

create table bank_pay_log(
  id int not null primary key auto_increment,
  userid varchar(40)   ,
  self_orderid varchar(40) not null comment '商城订单id',
  bank_orderid varchar(100) not null comment '银行支付网关',
  banktype varchar(10) not null comment '支付网关类型',
  pay_status varchar(10) not null ,
  createtm datetime comment '时间', 
  amount DOUBLE not null 
)engine=InnoDB;
