/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.common.service;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.common.service.BaseService;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.enumconst.CacheableTag;
import com.rocoinfo.rocomall.utils.ReflectionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.cache.RedisCacheManager;

public abstract class CrudService<D extends CrudDao<T>, T extends IdEntity>
extends BaseService<T> {
    @Autowired
    protected D entityDao;
    @Autowired
    protected RedisCacheManager cacheManager;

    @Override
    public T getById(Long id) {
        if (id == null || id < 1L) {
            return null;
        }
        return this.getAndSetToCacheIfRequired(id);
    }

    @Override
    public void insert(T entity) {
        if (entity == null) {
            return;
        }
        this.entityDao.insert(entity);
        this.evictCacheEntitysHook();
    }

    protected void evictCacheEntitysHook() {
    }

    @Override
    public void update(T entity) {
        if (entity == null) {
            return;
        }
        this.entityDao.update(entity);
        this.evictCachedEntityIfRequired(((IdEntity)entity).getId());
    }

    @Override
    public void deleteById(Long id) {
        if (id == null || id < 1L) {
            return;
        }
        this.entityDao.deleteById(id);
        this.evictCachedEntityIfRequired(id);
    }

    @Override
    public List<T> findAll() {
        return this.entityDao.findAll();
    }

    @Override
    public Page<T> searchScrollPage(Map<String, Object> params, Pageable pageable) {
        params.put("offset", pageable.getPageNumber());
        params.put("pageSize", pageable.getPageSize());
        params.put("sort", pageable.getSort());
        List pageData = Collections.emptyList();
        Long count = this.entityDao.searchTotal(params);
        if (count > 0L) {
            pageData = this.entityDao.search(params);
        }
        return new PageImpl(pageData, pageable, count.longValue());
    }

    private T getAndSetToCacheIfRequired(Long id) {
        IdEntity entity = null;
        CacheableTag cacheTag = this.getEntityCachableAnnotation();
        if (cacheTag != null && cacheTag.isCacheRequired()) {
            String key = cacheTag.cacheKeyPrev() + id;
            Cache cache = this.cacheManager.getCache("cache");
            Cache.ValueWrapper cachedEntity = cache.get((Object)key);
            if (cachedEntity != null) {
                entity = (IdEntity)cachedEntity.get();
            } else {
                entity = (IdEntity)this.entityDao.getById(id);
                if (entity != null) {
                    cache.put((Object)key, (Object)entity);
                }
            }
        } else {
            entity = (IdEntity)this.entityDao.getById(id);
        }
        return (T)entity;
    }

    private void evictCachedEntityIfRequired(Long id) {
        CacheableTag cacheTag = this.getEntityCachableAnnotation();
        if (cacheTag != null && cacheTag.isCacheRequired()) {
            String key = cacheTag.cacheKeyPrev() + id;
            Cache cache = this.cacheManager.getCache("cache");
            cache.evict((Object)key);
        }
        this.evictCacheEntitysHook();
    }

    private CacheableTag getEntityCachableAnnotation() {
        Class cls = ReflectionUtils.getSuperClassGenricType(this.getClass(), 1);
        if (cls.isAnnotationPresent(CacheableTag.class)) {
            CacheableTag cacheTag = cls.getAnnotation(CacheableTag.class);
            return cacheTag;
        }
        return null;
    }
}

