/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.StringUtils;

public class StatusDto<T> {
    protected String code;
    protected String message;
    protected T data;

    public StatusDto() {
    }

    public StatusDto(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public static StatusDto<String> buildSuccessStatusDto() {
        return StatusDto.buildSuccessStatusDto("Success");
    }

    public static <E> StatusDto<E> buildDataSuccessStatusDto() {
        return StatusDto.buildDataSuccessStatusDto("Success");
    }

    public static <E> StatusDto<E> buildDataSuccessStatusDto(String message) {
        StatusDto dto = new StatusDto();
        dto.code = "1";
        dto.message = message;
        return dto;
    }

    public static <E> StatusDto<E> buildDataSuccessStatusDto(String message, E data) {
        StatusDto<E> dto = StatusDto.buildDataSuccessStatusDto(message);
        dto.data = data;
        return dto;
    }

    public static StatusDto<String> buildSuccessStatusDto(String message) {
        StatusDto<String> dto = new StatusDto<String>();
        dto.code = "1";
        dto.message = message;
        return dto;
    }

    public static StatusDto<String> buildFailureStatusDto() {
        return StatusDto.buildFailureStatusDto("Failure");
    }

    public static StatusDto<String> buildFailureStatusDto(String message) {
        StatusDto<String> dto = new StatusDto<String>();
        dto.code = "0";
        dto.message = message;
        return dto;
    }

    public static <E> StatusDto<E> buildDataFailureStatusDto() {
        return StatusDto.buildDataFailureStatusDto("Failure");
    }

    public static <E> StatusDto<E> buildDataFailureStatusDto(String message) {
        StatusDto dto = new StatusDto();
        dto.code = "0";
        dto.message = message;
        return dto;
    }

    public static StatusDto<String> buildRefreshStatusDto(String message) {
        StatusDto<String> dto = new StatusDto<String>();
        dto.code = "300";
        dto.message = message;
        return dto;
    }

    @JsonIgnore
    public boolean isSuccess() {
        return StringUtils.equals((CharSequence)this.code, (CharSequence)"1");
    }

    public static StatusDto buildStatusDto(String message, String code) {
        StatusDto dto = new StatusDto();
        dto.code = code;
        dto.message = message;
        return dto;
    }
}

