/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.enumconst.CacheableTag;
import java.util.List;
import org.hibernate.validator.constraints.SafeHtml;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.data.annotation.Transient;
import org.springframework.format.annotation.NumberFormat;

@JsonIgnoreProperties(ignoreUnknown=true)
@CacheableTag(cacheKeyPrev="cache.catalog.")
public class Catalog
extends IdEntity {
    private static final long serialVersionUID = -33477870020039425L;
    private Catalog parent;
    private String name;
    private String code;
    private Integer displayOrder;
    private Status status;
    private List<Catalog> children;
    private String imgUrl;
    @Transient
    private Long parentId;

    public Catalog() {
    }

    public Catalog(long catId) {
        this();
        this.id = catId;
    }

    public Catalog getParent() {
        return this.parent;
    }

    @JsonIgnore
    public Long getParentId() {
        return this.parentId;
    }

    public void setParent(Catalog parent) {
        this.parent = parent;
    }

    @Required
    @SafeHtml
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Required
    @SafeHtml
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @NumberFormat
    public Integer getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(Integer displayOrder) {
        this.displayOrder = displayOrder;
    }

    @Required
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public List<Catalog> getChildren() {
        return this.children;
    }

    public void setChildren(List<Catalog> children) {
        this.children = children;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getImgUrl() {
        return this.imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getFullImageUrl() {
        return PropertyHolder.getFullImageUrl(this.getImgUrl());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Catalog other = (Catalog)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public static enum Status {
        BOTH_VISIBLE("\u5168\u90e8\u53ef\u89c1"),
        PC_VISIBLE("\u4ec5PC\u53ef\u89c1"),
        APP_VISIBLE("\u4ec5\u79fb\u52a8App\u53ef\u89c1"),
        INVISIBLE("\u90fd\u4e0d\u53ef\u89c1");

        private String label;

        private Status(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

