/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.entity.Brand;
import com.rocoinfo.rocomall.entity.Catalog;
import com.rocoinfo.rocomall.entity.Description;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.ProductImage;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.SkuMeta;
import com.rocoinfo.rocomall.entity.Supplier;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.data.annotation.Transient;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Product
extends IdEntity {
    private static final long serialVersionUID = -2385770727436538063L;
    private String name;
    private Brand brand;
    private String promotionWord;
    private Date listTime;
    private Date delistTime;
    private Supplier supplier;
    private SkuMeta skuMeta;
    private Description description;
    private Status status;
    private Boolean displayInlist;
    private Boolean visual;
    private PutType putType;
    @Transient
    private List<Catalog> catalogs;
    @Transient
    private List<Sku> skus;
    @Transient
    private List<ProductImage> productImages;
    @Transient
    private ProductImage mainImage;
    private ShowStatus showStatus;
    private Double cashAmt;
    private Double cent;
    private Double mergeCashAmt;
    private Double mergeCent;
    private String keyWorld;

    public Product() {
    }

    public Product(Long id) {
        this.id = id;
    }

    public Brand getBrand() {
        return this.brand;
    }

    public void setBrand(Brand brand) {
        this.brand = brand;
    }

    public Supplier getSupplier() {
        return this.supplier;
    }

    public void setSupplier(Supplier supplier) {
        this.supplier = supplier;
    }

    public SkuMeta getSkuMeta() {
        return this.skuMeta;
    }

    public void setSkuMeta(SkuMeta skuMeta) {
        this.skuMeta = skuMeta;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPromotionWord() {
        return this.promotionWord;
    }

    public void setPromotionWord(String promotionWord) {
        this.promotionWord = promotionWord;
    }

    public Date getListTime() {
        return this.listTime;
    }

    public void setListTime(Date listTime) {
        this.listTime = listTime;
    }

    public Date getDelistTime() {
        return this.delistTime;
    }

    public void setDelistTime(Date delistTime) {
        this.delistTime = delistTime;
    }

    public List<Sku> getSkus() {
        return this.skus;
    }

    public void setSkus(List<Sku> skus) {
        this.skus = skus;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public List<ProductImage> getProductImages() {
        return this.productImages;
    }

    public void setProductImages(List<ProductImage> productImages) {
        this.productImages = productImages;
    }

    public void addImage(ProductImage prodImg) {
        if (prodImg != null) {
            if (this.productImages == null) {
                this.productImages = Lists.newArrayList();
            }
            this.productImages.add(prodImg);
        }
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public List<Catalog> getCatalogs() {
        return this.catalogs;
    }

    public void setCatalogs(List<Catalog> catalogs) {
        this.catalogs = catalogs;
    }

    public void addCatalog(Catalog catelog) {
        if (catelog != null) {
            if (this.catalogs == null) {
                this.catalogs = new ArrayList<Catalog>();
            }
            if (!this.catalogs.contains(catelog)) {
                this.catalogs.add(catelog);
            }
        }
    }

    public ShowStatus getShowStatus() {
        return this.showStatus;
    }

    public void setShowStatus(ShowStatus showStatus) {
        this.showStatus = showStatus;
    }

    public Double getCashAmt() {
        return this.cashAmt;
    }

    public void setCashAmt(Double cashAmt) {
        this.cashAmt = cashAmt;
    }

    public Double getCent() {
        return this.cent;
    }

    public void setCent(Double cent) {
        this.cent = cent;
    }

    public Double getMergeCashAmt() {
        return this.mergeCashAmt;
    }

    public void setMergeCashAmt(Double mergeCashAmt) {
        this.mergeCashAmt = mergeCashAmt;
    }

    public Double getMergeCent() {
        return this.mergeCent;
    }

    public void setMergeCent(Double mergeCent) {
        this.mergeCent = mergeCent;
    }

    public String getKeyWorld() {
        return this.keyWorld;
    }

    public void setKeyWorld(String keyWorld) {
        this.keyWorld = keyWorld;
    }

    public Boolean getDisplayInlist() {
        return this.displayInlist;
    }

    public void setDisplayInlist(Boolean displayInlist) {
        this.displayInlist = displayInlist;
    }

    public Boolean getVisual() {
        return this.visual;
    }

    public void setVisual(Boolean visual) {
        this.visual = visual;
    }

    public PutType getPutType() {
        return this.putType;
    }

    public void setPutType(PutType putType) {
        this.putType = putType;
    }

    public ProductImage getMainImage() {
        return this.mainImage;
    }

    public void setMainImage(ProductImage mainImage) {
        this.mainImage = mainImage;
    }

    public static enum PutType {
        MANUAL("\u624b\u52a8\u53d1\u653e"),
        AUTO("\u81ea\u52a8\u53d1\u653e");

        private String label;

        private PutType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum Status {
        DRAFT("\u8349\u7a3f"),
        AUDIT("\u5ba1\u6279\u4e2d"),
        READY_LIST("\u5f85\u4e0a\u67b6"),
        REFUSE("\u5df2\u62d2\u7edd"),
        LIST("\u5df2\u4e0a\u67b6"),
        DELIST("\u5df2\u4e0b\u67b6"),
        DISCARD("\u5df2\u4f5c\u5e9f");

        private String label;

        private Status(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum ShowStatus {
        BOTH_VISIBLE("\u5168\u90e8\u53ef\u89c1"),
        PC_VISIBLE("\u4ec5PC\u53ef\u89c1"),
        WAP_VISIBLE("\u4ec5WAP\u53ef\u89c1");

        private String label;

        private ShowStatus(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

