/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.entity.cent;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.dict.DictCentAttribution;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CentRule
extends IdEntity {
    private static final long serialVersionUID = 1L;
    private String code;
    private String name;
    private String description;
    private DictCentAttribution attribution;
    private String secretKey;
    private Integer cent;
    private Integer budget;
    private Integer totalCent;
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    private Date startDate;
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    private Date endDate;
    private Integer effectiveType;
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    private Date effectiveDate;
    private Integer extendDay;
    private Boolean smsFlag;
    private Status status;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DictCentAttribution getAttribution() {
        return this.attribution;
    }

    public void setAttribution(DictCentAttribution attribution) {
        this.attribution = attribution;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public Integer getCent() {
        return this.cent;
    }

    public void setCent(Integer cent) {
        this.cent = cent;
    }

    public Integer getBudget() {
        return this.budget;
    }

    public void setBudget(Integer budget) {
        this.budget = budget;
    }

    public Integer getTotalCent() {
        return this.totalCent;
    }

    public void setTotalCent(Integer totalCent) {
        this.totalCent = totalCent;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Integer getEffectiveType() {
        return this.effectiveType;
    }

    public void setEffectiveType(Integer effectiveType) {
        this.effectiveType = effectiveType;
    }

    public Integer getExtendDay() {
        return this.extendDay;
    }

    public void setExtendDay(Integer extendDay) {
        this.extendDay = extendDay;
    }

    public Boolean getSmsFlag() {
        return this.smsFlag;
    }

    public void setSmsFlag(Boolean smsFlag) {
        this.smsFlag = smsFlag;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isUsable() {
        return this.isEffective() && Status.OPEN.equals((Object)this.status) && this.getBudgetBalance() > 0;
    }

    public boolean isEffective() {
        java.sql.Date now = new java.sql.Date(System.currentTimeMillis());
        if (this.startDate == null || now.before(this.startDate)) {
            return false;
        }
        return this.endDate == null || !now.after(this.endDate);
    }

    public Integer getBudgetBalance() {
        if (this.budget != null && this.totalCent != null) {
            return Math.max(this.budget - this.totalCent, 0);
        }
        return null;
    }

    public static enum Status {
        DRAFT("\u8349\u7a3f"),
        WAIT_AUDIT("\u5f85\u5ba1\u6279"),
        OPEN("\u5f00\u542f"),
        LOCK("\u505c\u6b62");

        private String label;

        private Status(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

