/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.entity.order;

import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.entity.Address;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.order.OrderDelivery;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.data.annotation.Transient;

public class Order
extends IdEntity {
    private static final long serialVersionUID = -8411839450593890824L;
    private String orderCode;
    private User user;
    private String userLevelName;
    private DeliveryTimePreference deliveryTimePreference;
    private InvoiceType invoiceType;
    private String invoiceTitle;
    private PaymentType paymentType;
    private CashPayType cashPayType;
    private Double deliverFee;
    private Double cashAmt;
    private Integer cent;
    private CheckState checkState;
    private Boolean distributed;
    private Boolean locked;
    private Boolean clickedLockBtn;
    private String tradeNo;
    private String tradeState;
    private Boolean cashPayed;
    private Boolean centPayed;
    private Date payedTime;
    private String note;
    private Date createTime;
    @Transient
    private List<OrderItem> items;
    @Transient
    private OrderDelivery delivery;
    private String cancelReason;
    private Boolean isInvite;
    private Long addressId;
    private Address orderAddress;

    public Order() {
    }

    public Order(Long id) {
        this.id = id;
    }

    public String getOrderCode() {
        return this.orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public DeliveryTimePreference getDeliveryTimePreference() {
        return this.deliveryTimePreference;
    }

    public void setDeliveryTimePreference(DeliveryTimePreference deliveryTimePreference) {
        this.deliveryTimePreference = deliveryTimePreference;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public List<OrderItem> getItems() {
        return this.items;
    }

    public void setItems(List<OrderItem> items) {
        this.items = items;
    }

    public void addItem(OrderItem orderItem) {
        if (orderItem != null) {
            if (this.items == null) {
                this.items = Lists.newArrayList();
            }
            this.items.add(orderItem);
        }
    }

    public int getTotalSavedCent() {
        int totalSaved = 0;
        if (CollectionUtils.isNotEmpty(this.items)) {
            for (OrderItem orderItem : this.items) {
                int itemSaved = (orderItem.getOriginalCent() - orderItem.getCent()) * orderItem.getQuantity();
                totalSaved += itemSaved;
            }
        }
        return totalSaved;
    }

    public InvoiceType getInvoiceType() {
        return this.invoiceType;
    }

    public void setInvoiceType(InvoiceType invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getInvoiceTitle() {
        return this.invoiceTitle;
    }

    public void setInvoiceTitle(String invoiceTitle) {
        this.invoiceTitle = invoiceTitle;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public CashPayType getCashPayType() {
        return this.cashPayType;
    }

    public void setCashPayType(CashPayType cashPayType) {
        this.cashPayType = cashPayType;
    }

    public Double getDeliverFee() {
        return this.deliverFee;
    }

    public void setDeliverFee(Double deliverFee) {
        this.deliverFee = deliverFee;
    }

    public Double getCashAmt() {
        return this.cashAmt;
    }

    public void setCashAmt(Double cashAmt) {
        this.cashAmt = cashAmt;
    }

    public Integer getCent() {
        return this.cent;
    }

    public void setCent(Integer cent) {
        this.cent = cent;
    }

    public String getUserLevelName() {
        return this.userLevelName;
    }

    public void setUserLevelName(String userLevelName) {
        this.userLevelName = userLevelName;
    }

    public OrderDelivery getDelivery() {
        return this.delivery;
    }

    public void setDelivery(OrderDelivery delivery) {
        this.delivery = delivery;
    }

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getTradeState() {
        return this.tradeState;
    }

    public void setTradeState(String tradeState) {
        this.tradeState = tradeState;
    }

    public Boolean getCashPayed() {
        return this.cashPayed;
    }

    public void setCashPayed(Boolean cashPayed) {
        this.cashPayed = cashPayed;
    }

    public Boolean getCentPayed() {
        return this.centPayed;
    }

    public void setCentPayed(Boolean centPayed) {
        this.centPayed = centPayed;
    }

    public Date getPayedTime() {
        return this.payedTime;
    }

    public void setPayedTime(Date payedTime) {
        this.payedTime = payedTime;
    }

    public CheckState getCheckState() {
        return this.checkState;
    }

    public void setCheckState(CheckState checkState) {
        this.checkState = checkState;
    }

    public Boolean getDistributed() {
        return this.distributed;
    }

    public void setDistributed(Boolean distributed) {
        this.distributed = distributed;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public Boolean getClickedLockBtn() {
        return this.clickedLockBtn;
    }

    public void setClickedLockBtn(Boolean clickedLockBtn) {
        this.clickedLockBtn = clickedLockBtn;
    }

    public Address getOrderAddress() {
        return this.orderAddress;
    }

    public void setOrderAddress(Address orderAddress) {
        this.orderAddress = orderAddress;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }

    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public Boolean getIsInvite() {
        return this.isInvite;
    }

    public void setIsInvite(Boolean isInvite) {
        this.isInvite = isInvite;
    }

    public Long getAddressId() {
        return this.addressId;
    }

    public void setAddressId(Long addressId) {
        this.addressId = addressId;
    }

    public static enum DeliveryTimePreference {
        WEEKDAYS("\u53ea\u5de5\u4f5c\u65e5\u9001\u8d27"),
        WEEKENDS("\u53ea\u53cc\u4f11\u65e5\u3001\u5047\u65e5\u9001\u8d27 "),
        ANYDAY("\u5de5\u4f5c\u65e5\u3001\u53cc\u4f11\u65e5\u6216\u5047\u65e5\u5747\u53ef\u9001\u8d27");

        private String label;

        private DeliveryTimePreference(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum CheckState {
        EXCEPTION("\u5f02\u5e38"),
        NORMAL("\u6b63\u5e38");

        private String label;

        private CheckState(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum InvoiceType {
        NONE("\u4e0d\u5f00\u53d1\u7968"),
        PERSONAL("\u4e2a\u4eba"),
        COMPANY("\u5355\u4f4d");

        private String label;

        private InvoiceType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum CashPayType {
        UNIONPAY("\u94f6\u8054"),
        ALIPAY("\u652f\u4ed8\u5b9d"),
        WXPAY("\u5fae\u4fe1");

        private String label;

        private CashPayType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum PaymentType {
        CASH("\u5168\u73b0\u91d1"),
        CENT("\u5168\u79ef\u5206"),
        CASH_AND_CENT("\u79ef\u5206+\u73b0\u91d1");

        private String label;

        private PaymentType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

