/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class OrderStatusMessageProducer {
    private Logger logger = LoggerFactory.getLogger(OrderStatusMessageProducer.class);
    private JmsTemplate jmsTemplate;
    private Destination notifyQueue;

    public void sendQueue(final String orderCode, final String status) {
        this.logger.debug("\u6b63\u5728\u53d1\u9001JMS\u6d88\u606f\u3002orderCode={}, status={}", (Object)orderCode, (Object)status);
        this.jmsTemplate.send(this.notifyQueue, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                MapMessage mapMessage = session.createMapMessage();
                mapMessage.setString("orderCode", orderCode);
                mapMessage.setString("status", status);
                return mapMessage;
            }
        });
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setNotifyQueue(Destination notifyQueue) {
        this.notifyQueue = notifyQueue;
    }
}

