/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.pay.alipay;

import com.rocoinfo.rocomall.pay.MD5;
import com.rocoinfo.rocomall.pay.alipay.AlipayCore;
import com.rocoinfo.rocomall.pay.alipay.AlipayNotify;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlipayInterfaceHelper {
    private static Logger logger = LoggerFactory.getLogger(AlipayInterfaceHelper.class);
    public static String partner;
    public static String key;
    public static String seller_email;
    public static final String input_charset = "utf-8";
    public static final String sign_type = "MD5";
    public static final String type = "1";
    public static final String ALIPAY_GATEWAY_NEW = "https://mapi.alipay.com/gateway.do";

    public static Map<String, String> buildQueryParam(AlipayQueryBaseMeta baseMeta) {
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        sParaTemp.put("service", "create_direct_pay_by_user");
        sParaTemp.put("partner", partner);
        sParaTemp.put("_input_charset", input_charset);
        if (StringUtils.isNotBlank((CharSequence)baseMeta.getNotifyUrl())) {
            sParaTemp.put("notify_url", baseMeta.getNotifyUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)baseMeta.getReturnUrl())) {
            sParaTemp.put("return_url", baseMeta.getReturnUrl());
        }
        sParaTemp.put("out_trade_no", baseMeta.getOutTradeNo());
        sParaTemp.put("subject", baseMeta.getSubject());
        sParaTemp.put("payment_type", type);
        sParaTemp.put("total_fee", String.valueOf(baseMeta.getTotalFee()));
        if (StringUtils.isNotBlank((CharSequence)seller_email)) {
            sParaTemp.put("seller_email", seller_email);
        }
        if (StringUtils.isNotBlank((CharSequence)baseMeta.getBody())) {
            sParaTemp.put("body", baseMeta.getBody());
        }
        if (StringUtils.isNotBlank((CharSequence)baseMeta.getShowUrl())) {
            sParaTemp.put("show_url", baseMeta.getShowUrl());
        }
        return AlipayInterfaceHelper.buildRequestPara(sParaTemp);
    }

    public static boolean validateReturnMsg(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            logger.info("{}------{}", (Object)name, (Object)valueStr);
            params.put(name, valueStr);
        }
        boolean isSignOk = AlipayNotify.verify(params);
        logger.info("\u6570\u636e\u5408\u6cd5\u6027{}", (Object)isSignOk);
        return isSignOk;
    }

    public static boolean isPaySuccess(HttpServletRequest request) {
        String tradeStatus = request.getParameter("trade_status");
        if (AlipayInterfaceHelper.validateReturnMsg(request)) {
            boolean isPaySuccess = StringUtils.isNotBlank((CharSequence)tradeStatus) && (StringUtils.equals((CharSequence)tradeStatus, (CharSequence)"TRADE_SUCCESS") || StringUtils.equals((CharSequence)tradeStatus, (CharSequence)"TRADE_FINISHED"));
            logger.info("\u4ea4\u6613\u72b6\u6001{}", (Object)isPaySuccess);
            return isPaySuccess;
        }
        return false;
    }

    private static Map<String, String> buildRequestPara(Map<String, String> sParaTemp) {
        Map<String, String> sPara = AlipayCore.paraFilter(sParaTemp);
        String mysign = AlipayInterfaceHelper.buildRequestMysign(sPara);
        sPara.put("sign_type", sign_type);
        sPara.put("sign", mysign);
        return sPara;
    }

    private static String buildRequestMysign(Map<String, String> sPara) {
        String prestr = AlipayCore.createLinkString(sPara);
        String mysign = "";
        if (sign_type.equals(sign_type)) {
            mysign = MD5.sign(prestr, key, input_charset);
        }
        return mysign;
    }

    public static class AlipayQueryBaseMeta {
        private String notifyUrl;
        private String returnUrl;
        private String outTradeNo;
        private String subject;
        private double totalFee;
        private String body;
        private String showUrl;

        public AlipayQueryBaseMeta(String outTradeNo, String subject, double totalFee) {
            this.outTradeNo = outTradeNo;
            this.subject = subject;
            this.totalFee = totalFee;
        }

        public AlipayQueryBaseMeta(String outTradeNo, String subject, double totalFee, String returnUrl, String notifyUrl) {
            this(outTradeNo, subject, totalFee);
            this.returnUrl = returnUrl;
            this.notifyUrl = notifyUrl;
        }

        public String getNotifyUrl() {
            return this.notifyUrl;
        }

        public void setNotifyUrl(String notifyUrl) {
            this.notifyUrl = notifyUrl;
        }

        public String getReturnUrl() {
            return this.returnUrl;
        }

        public void setReturnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
        }

        public String getOutTradeNo() {
            return this.outTradeNo;
        }

        public void setOutTradeNo(String outTradeNo) {
            this.outTradeNo = outTradeNo;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public double getTotalFee() {
            return this.totalFee;
        }

        public void setTotalFee(double totalFee) {
            this.totalFee = totalFee;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public String getShowUrl() {
            return this.showUrl;
        }

        public void setShowUrl(String showUrl) {
            this.showUrl = showUrl;
        }
    }
}

