/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.pay.chinabank;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.pay.MD5;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChinaBankPayHelper {
    private static Logger logger = LoggerFactory.getLogger(ChinaBankPayHelper.class);
    public static String v_mid;
    public static String key;
    public static final String v_moneytype = "CNY";
    public static final String CHINABANK_GATEWAY_NEW = "https://pay3.chinabank.com.cn/PayGate";

    public static Map<String, String> buildQueryParam(ChBankQueryBaseMeta baseMeta) {
        HashMap params = Maps.newHashMap();
        params.put("v_mid", v_mid);
        params.put("v_oid", baseMeta.getOrderid());
        params.put("v_amount", String.valueOf(baseMeta.getVamount()));
        params.put("v_moneytype", v_moneytype);
        params.put("v_url", baseMeta.getVurl());
        String text = baseMeta.getVamount() + v_moneytype + baseMeta.getOrderid() + v_mid + baseMeta.getVurl() + key;
        String v_md5info = MD5.getMD5ofStr(text);
        params.put("v_md5info", v_md5info);
        if (StringUtils.isNotBlank((CharSequence)baseMeta.getRemark2())) {
            params.put("remark2", baseMeta.getRemark2());
        }
        return params;
    }

    public static boolean validateData(HttpServletRequest request) {
        String v_oid = request.getParameter("v_oid");
        String v_pstatus = request.getParameter("v_pstatus");
        String v_amount = request.getParameter("v_amount");
        String v_moneytype = request.getParameter("v_moneytype");
        String v_md5str = request.getParameter("v_md5str");
        String v_md5info = MD5.getMD5ofStr(v_oid + v_pstatus + v_amount + v_moneytype + key).toUpperCase();
        boolean result = StringUtils.equals((CharSequence)v_md5info, (CharSequence)v_md5str);
        logger.info("\u6570\u636e\u9a8c\u8bc1\u7ed3\u679c:{}", (Object)result);
        return result;
    }

    public static boolean isPaySuccess(HttpServletRequest request) {
        String pstatus = request.getParameter("v_pstatus");
        return ChinaBankPayHelper.validateData(request) && StringUtils.equals((CharSequence)"20", (CharSequence)pstatus);
    }

    public static class ChBankQueryBaseMeta {
        private String orderid;
        private double vamount;
        private String vurl;
        private String remark2;

        public ChBankQueryBaseMeta(String orderid, double vamount, String vurl, String remark2) {
            this.orderid = orderid;
            this.vamount = vamount;
            this.vurl = vurl;
            this.remark2 = "[url:=" + remark2 + "]";
        }

        public String getOrderid() {
            return this.orderid;
        }

        public double getVamount() {
            return this.vamount;
        }

        public String getVurl() {
            return this.vurl;
        }

        public String getRemark2() {
            return this.remark2;
        }

        public void setRemark2(String remark2) {
            this.remark2 = "[url:=" + remark2 + "]";
        }

        public void setOrderid(String orderid) {
            this.orderid = orderid;
        }

        public void setVamount(double vamount) {
            this.vamount = vamount;
        }

        public void setVurl(String vurl) {
            this.vurl = vurl;
        }
    }
}

