/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.pay.chinapay;

import chinapay.PrivateKey;
import chinapay.SecureLink;
import com.google.common.collect.Maps;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChinaPayInterfaceHelper {
    private static Logger logger = LoggerFactory.getLogger(ChinaPayInterfaceHelper.class);
    public static String MERID;
    public static String PUBLIC_MERID;
    public static String PUBLIC_KEY;
    public static String PRIVATE_KEY;
    public static final String CURYID = "156";
    public static final String TRANSTYPE = "0001";
    public static final String VERSION = "20070129";
    public static final String URL = "https://payment.chinapay.com/pay/TransGet";

    public static Map<String, String> buildQueryParam(String orderId, double transAmt, String notify_url, String return_url) {
        HashMap params = Maps.newHashMap();
        params.put("MerId", MERID);
        params.put("OrdId", orderId);
        String transAmtstr = ChinaPayInterfaceHelper.formatMoney(transAmt);
        params.put("TransAmt", transAmtstr);
        params.put("CuryId", CURYID);
        String dataStr = DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd");
        params.put("TransDate", dataStr);
        params.put("TransType", TRANSTYPE);
        params.put("Version", VERSION);
        params.put("BgRetUrl", notify_url);
        params.put("PageRetUrl", return_url);
        PrivateKey key = new PrivateKey();
        boolean keyLoaded = key.buildKey(MERID, 0, PRIVATE_KEY);
        logger.info("\u7b7e\u540d\u5bfc\u5165key:{}", (Object)keyLoaded);
        if (!keyLoaded) {
            return null;
        }
        SecureLink link = new SecureLink(key);
        String chkValue = link.signOrder(MERID, orderId, transAmtstr, CURYID, dataStr, TRANSTYPE);
        params.put("ChkValue", chkValue);
        return params;
    }

    public static boolean isPaySuccess(HttpServletRequest request) {
        String tradeDate = request.getParameter("transdate");
        String merId = request.getParameter("merid");
        String ordId = request.getParameter("orderno");
        String transType = request.getParameter("transtype");
        String transAmt = request.getParameter("amount");
        String curyId = request.getParameter("currencycode");
        String orderStatus = request.getParameter("status");
        String chkValue = request.getParameter("checkvalue");
        PrivateKey key = new PrivateKey();
        boolean keyLoaded = false;
        boolean verifyReturnResult = false;
        keyLoaded = key.buildKey(PUBLIC_MERID, 0, PUBLIC_KEY);
        logger.info("\u9a8c\u8bc1\u5bfc\u5165key:{}", (Object)keyLoaded);
        if (keyLoaded) {
            SecureLink link = new SecureLink(key);
            verifyReturnResult = link.verifyTransResponse(merId, ordId, transAmt, curyId, tradeDate, transType, orderStatus, chkValue);
            logger.info("\u652f\u4ed8\u9a8c\u8bc1\u7ed3\u679c{}.orderStatus:{}", (Object)verifyReturnResult, (Object)orderStatus);
            if (verifyReturnResult && "1001".equals(orderStatus)) {
                return true;
            }
        }
        return false;
    }

    private static String formatMoney(double amount) {
        DecimalFormat df = new DecimalFormat("000000000000");
        String money = df.format(amount *= 100.0);
        return money;
    }
}

