/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.pay.kuaiqian;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.pay.kuaiqian.KuaiQianParm;
import com.rocoinfo.rocomall.pay.kuaiqian.Pkipair;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KuaiQianPayHelper {
    private static Logger logger = LoggerFactory.getLogger(KuaiQianPayHelper.class);
    public static final String URL = "https://sandbox.99bill.com/gateway/recvMerchantInfoAction.htm";
    public static String MERCHANTACCTID;
    public static String KEY;
    public static String KEY_NAME;
    public static String PRIVATE_RSA_PATH;
    public static String PUBLIC_RSA_PATH;

    public static Map<String, String> buildQueryParam(KuaiQianParm parm) {
        KuaiQianPayHelper.sign(parm);
        HashMap params = Maps.newHashMap();
        params.put("inputCharset", parm.getInputCharset());
        params.put("bgUrl", parm.getBgUrl());
        params.put("version", parm.getVersion());
        params.put("language", parm.getLanguage());
        params.put("signType", parm.getSignType());
        params.put("signMsg", parm.getSignMsg());
        params.put("merchantAcctId", MERCHANTACCTID);
        params.put("orderId", parm.getOrderId());
        params.put("orderAmount", parm.getOrderAmount());
        params.put("orderTime", parm.getOrderTime());
        params.put("payType", parm.getPayType());
        return params;
    }

    public static void sign(KuaiQianParm parm) {
        String signMsgVal = "";
        signMsgVal = KuaiQianPayHelper.appendParam(signMsgVal, "inputCharset", parm.getInputCharset());
        signMsgVal = KuaiQianPayHelper.appendParam(signMsgVal, "pageUrl", parm.getPageUrl());
        signMsgVal = KuaiQianPayHelper.appendParam(signMsgVal, "bgUrl", parm.getBgUrl());
        signMsgVal = KuaiQianPayHelper.appendParam(signMsgVal, "version", parm.getVersion());
        signMsgVal = KuaiQianPayHelper.appendParam(signMsgVal, "language", parm.getLanguage());
        signMsgVal = KuaiQianPayHelper.appendParam(signMsgVal, "signType", parm.getSignType());
        signMsgVal = KuaiQianPayHelper.appendParam(signMsgVal, "merchantAcctId", MERCHANTACCTID);
        signMsgVal = KuaiQianPayHelper.appendParam(signMsgVal, "orderId", parm.getOrderId());
        signMsgVal = KuaiQianPayHelper.appendParam(signMsgVal, "orderAmount", parm.getOrderAmount());
        signMsgVal = KuaiQianPayHelper.appendParam(signMsgVal, "orderTime", parm.getOrderTime());
        signMsgVal = KuaiQianPayHelper.appendParam(signMsgVal, "payType", parm.getPayType());
        Pkipair pki = new Pkipair();
        logger.info("\u7b7e\u540d\u5b57\u7b26\u4e32:{}", (Object)signMsgVal);
        parm.setSignMsg(pki.signMsg(signMsgVal));
    }

    public static boolean validateData(HttpServletRequest request) {
        String merchantAcctId = request.getParameter("merchantAcctId");
        String version = request.getParameter("version");
        String language = request.getParameter("language");
        String signType = request.getParameter("signType");
        String payType = request.getParameter("payType");
        String bankId = request.getParameter("bankId");
        String orderId = request.getParameter("orderId");
        String orderTime = request.getParameter("orderTime");
        String orderAmount = request.getParameter("orderAmount");
        String dealId = request.getParameter("dealId");
        String bankDealId = request.getParameter("bankDealId");
        String dealTime = request.getParameter("dealTime");
        String payAmount = request.getParameter("payAmount");
        String fee = request.getParameter("fee");
        String ext1 = request.getParameter("ext1");
        String ext2 = request.getParameter("ext2");
        String payResult = request.getParameter("payResult");
        String errCode = request.getParameter("errCode");
        String signMsg = request.getParameter("signMsg");
        String merchantSignMsgVal = "";
        merchantSignMsgVal = KuaiQianPayHelper.appendParam(merchantSignMsgVal, "merchantAcctId", merchantAcctId);
        merchantSignMsgVal = KuaiQianPayHelper.appendParam(merchantSignMsgVal, "version", version);
        merchantSignMsgVal = KuaiQianPayHelper.appendParam(merchantSignMsgVal, "language", language);
        merchantSignMsgVal = KuaiQianPayHelper.appendParam(merchantSignMsgVal, "signType", signType);
        merchantSignMsgVal = KuaiQianPayHelper.appendParam(merchantSignMsgVal, "payType", payType);
        merchantSignMsgVal = KuaiQianPayHelper.appendParam(merchantSignMsgVal, "bankId", bankId);
        merchantSignMsgVal = KuaiQianPayHelper.appendParam(merchantSignMsgVal, "orderId", orderId);
        merchantSignMsgVal = KuaiQianPayHelper.appendParam(merchantSignMsgVal, "orderTime", orderTime);
        merchantSignMsgVal = KuaiQianPayHelper.appendParam(merchantSignMsgVal, "orderAmount", orderAmount);
        merchantSignMsgVal = KuaiQianPayHelper.appendParam(merchantSignMsgVal, "dealId", dealId);
        merchantSignMsgVal = KuaiQianPayHelper.appendParam(merchantSignMsgVal, "bankDealId", bankDealId);
        merchantSignMsgVal = KuaiQianPayHelper.appendParam(merchantSignMsgVal, "dealTime", dealTime);
        merchantSignMsgVal = KuaiQianPayHelper.appendParam(merchantSignMsgVal, "payAmount", payAmount);
        merchantSignMsgVal = KuaiQianPayHelper.appendParam(merchantSignMsgVal, "fee", fee);
        merchantSignMsgVal = KuaiQianPayHelper.appendParam(merchantSignMsgVal, "ext1", ext1);
        merchantSignMsgVal = KuaiQianPayHelper.appendParam(merchantSignMsgVal, "ext2", ext2);
        merchantSignMsgVal = KuaiQianPayHelper.appendParam(merchantSignMsgVal, "payResult", payResult);
        merchantSignMsgVal = KuaiQianPayHelper.appendParam(merchantSignMsgVal, "errCode", errCode);
        Pkipair pki = new Pkipair();
        return pki.enCodeByCer(merchantSignMsgVal, signMsg);
    }

    public static boolean isPaySuccess(HttpServletRequest request) {
        boolean isSignOk = KuaiQianPayHelper.validateData(request);
        logger.info("\u6570\u636e\u6821\u9a8c\u7ed3\u679c:{}", (Object)isSignOk);
        if (isSignOk) {
            String payResult = request.getParameter("payResult");
            return StringUtils.equals((CharSequence)payResult, (CharSequence)"10");
        }
        return false;
    }

    private static String appendParam(String returns, String paramId, String paramValue) {
        if (StringUtils.isNotBlank((CharSequence)returns)) {
            if (StringUtils.isNotBlank((CharSequence)paramValue) && !StringUtils.equals((CharSequence)"null", (CharSequence)paramValue)) {
                returns = returns + "&" + paramId + "=" + paramValue;
            }
        } else if (StringUtils.isNotBlank((CharSequence)paramValue) && !StringUtils.equals((CharSequence)"null", (CharSequence)paramValue)) {
            returns = paramId + "=" + paramValue;
        }
        return returns;
    }
}

