/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.pay.wechat;

import com.rocoinfo.rocomall.pay.chinapay.ChinaPayInterfaceHelper;
import com.rocoinfo.rocomall.pay.wechat.NotifyResultParm;
import com.rocoinfo.rocomall.pay.wechat.UnifiedOrderParm;
import com.rocoinfo.rocomall.pay.wechat.UnifiedOrderResult;
import com.rocoinfo.rocomall.pay.wechat.WxSignUtil;
import com.rocoinfo.rocomall.utils.RestTemplateUtil;
import com.rocoinfo.rocomall.utils.XmlUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class WxpayHelper {
    private static Logger logger = LoggerFactory.getLogger(ChinaPayInterfaceHelper.class);
    public static String APPID;
    public static String MCHID;
    public static String SIGNATURE;
    public static String url;
    public static String SUCCESS;

    public static UnifiedOrderResult wxUnifiedorder(UnifiedOrderParm parm) {
        parm.setAppId(APPID);
        parm.setMchId(MCHID);
        parm.setSign(WxSignUtil.sign(parm.getClass(), parm, SIGNATURE));
        RestTemplate restTemplates = RestTemplateUtil.getRestTemplateUtf8();
        String reqXml = XmlUtil.convertToXml(parm, "utf-8");
        logger.info("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u8bf7\u6c42xml{}", (Object)reqXml);
        String returnXml = (String)restTemplates.postForObject(url, (Object)reqXml, String.class, new Object[0]);
        logger.info("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u8fd4\u56dexml{}", (Object)returnXml);
        if (StringUtils.isNotBlank((CharSequence)returnXml)) {
            return XmlUtil.converyToJavaBean(returnXml, UnifiedOrderResult.class);
        }
        return null;
    }

    public static boolean validateUnifiedOrderSign(UnifiedOrderResult result) {
        if (result.isCanPay()) {
            return StringUtils.equals((CharSequence)WxSignUtil.sign(result.getClass(), result, SIGNATURE), (CharSequence)result.getSign());
        }
        return false;
    }

    public static boolean isPaySuccess(NotifyResultParm result) {
        boolean status = result.isPaySuccess();
        if (status) {
            return StringUtils.equals((CharSequence)WxSignUtil.sign(result.getClass(), result, SIGNATURE), (CharSequence)result.getSign());
        }
        return false;
    }

    static {
        url = "https://api.mch.weixin.qq.com/pay/unifiedorder";
        SUCCESS = "SUCCESS";
    }
}

