/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.redis;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

public final class JedisSentinelConnectionFactory
implements DisposableBean,
RedisConnectionFactory {
    private static Logger log = LoggerFactory.getLogger(JedisSentinelConnectionFactory.class);
    private Pool<Jedis> pool = null;
    private int dbIndex = 0;
    private boolean convertPipelineAndTxResults = true;

    public JedisSentinelConnectionFactory(Pool<Jedis> pool) {
        this(pool, 0);
    }

    public JedisSentinelConnectionFactory(Pool<Jedis> pool, int dbIndex) {
        this.pool = pool;
        this.dbIndex = dbIndex;
    }

    protected Jedis fetchJedisConnector() {
        try {
            return (Jedis)this.pool.getResource();
        }
        catch (Exception ex) {
            throw new RedisConnectionFailureException("Cannot get Jedis connection", (Throwable)ex);
        }
    }

    protected JedisConnection postProcessConnection(JedisConnection connection) {
        return connection;
    }

    public void destroy() {
        try {
            this.pool.destroy();
        }
        catch (Exception ex) {
            log.warn("Cannot properly close Jedis pool", (Throwable)ex);
        }
        this.pool = null;
    }

    public JedisConnection getConnection() {
        Jedis jedis = this.fetchJedisConnector();
        JedisConnection connection = new JedisConnection(jedis, this.pool, this.dbIndex);
        connection.setConvertPipelineAndTxResults(this.convertPipelineAndTxResults);
        return this.postProcessConnection(connection);
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return JedisConverters.toDataAccessException((Exception)ex);
    }

    public int getDatabase() {
        return this.dbIndex;
    }

    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"invalid DB index (a positive index required)");
        this.dbIndex = index;
    }

    public boolean getConvertPipelineAndTxResults() {
        return this.convertPipelineAndTxResults;
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    public RedisSentinelConnection getSentinelConnection() {
        return null;
    }
}

