/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.redis;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;
import org.springside.modules.nosql.redis.JedisUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.util.Pool;

public class JedisTemplate {
    private static Logger logger = LoggerFactory.getLogger(JedisTemplate.class);
    private static RedisSerializer<Object> valueSerializer = new JdkSerializationRedisSerializer();
    private final Pool<Jedis> jedisPool;
    private int dbIndex;

    public JedisTemplate(Pool<Jedis> jedisPool) {
        this.jedisPool = jedisPool;
    }

    public <T> T execute(JedisAction<T> jedisAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.jedisPool.getResource();
            jedis.select(this.dbIndex);
            T t = jedisAction.action(jedis);
            return t;
        }
        catch (JedisConnectionException e) {
            logger.error("Redis connection lost.", (Throwable)e);
            broken = true;
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    public void execute(JedisActionNoResult jedisAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.jedisPool.getResource();
            jedis.select(this.dbIndex);
            jedisAction.action(jedis);
        }
        catch (JedisConnectionException e) {
            logger.error("Redis connection lost.", (Throwable)e);
            broken = true;
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    public void subscribe(final JedisPubSub pubSub, final String ... channels) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.subscribe(pubSub, channels);
            }
        });
    }

    public void publish(final String channel, final Serializable message) {
        if (StringUtils.isBlank((CharSequence)channel) || message == null) {
            return;
        }
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.publish(channel, (String)((Object)message));
            }
        });
    }

    protected void closeResource(Jedis jedis, boolean connectionBroken) {
        if (jedis != null) {
            try {
                if (connectionBroken) {
                    this.jedisPool.returnBrokenResource((Object)jedis);
                } else {
                    this.jedisPool.returnResource((Object)jedis);
                }
            }
            catch (Exception e) {
                logger.error("Error happen when return jedis to pool, try to close it directly.", (Throwable)e);
                JedisUtils.closeJedis((Jedis)jedis);
            }
        }
    }

    public Long incrByOptimisticLock(final String counterKey) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                jedis.watch(new String[]{counterKey});
                Transaction redisTranct = jedis.multi();
                redisTranct.incr(counterKey);
                List result = redisTranct.exec();
                if (result != null && result.size() == 1) {
                    return NumberUtils.toLong((String)result.get(0).toString());
                }
                return null;
            }
        });
    }

    public void executeByOptimisticLock(final String lockCounter, final BussiCallback action) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.watch(new String[]{lockCounter});
                Transaction redisTranct = jedis.multi();
                redisTranct.incr(lockCounter);
                action.doBussiInAction();
                List result = redisTranct.exec();
                if (result == null) {
                    action.rollback();
                }
            }
        });
    }

    public Pool<Jedis> getJedisPool() {
        return this.jedisPool;
    }

    public Boolean del(final String ... keys) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.del(keys) == 1L;
            }
        });
    }

    public void flushDB() {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.flushDB();
            }
        });
    }

    public String get(final String key) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.get(key);
            }
        });
    }

    public boolean hasKey(final String key) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.exists(key);
            }
        });
    }

    public boolean expire(final String key, final int seconds) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.expire(key, seconds) == 1L;
            }
        });
    }

    public boolean expireAt(final String key, final long expireAt) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.expireAt(key, expireAt) == 1L;
            }
        });
    }

    public Long getAsLong(String key) {
        String result = this.get(key);
        return result != null ? Long.valueOf(NumberUtils.toLong((String)result)) : null;
    }

    public Long getAsLong(String key, Long defautValue) {
        Long num = this.getAsLong(key);
        return num != null ? num : defautValue;
    }

    public Integer getAsInt(String key) {
        String result = this.get(key);
        return result != null ? Integer.valueOf(NumberUtils.toInt((String)result)) : null;
    }

    public Integer getAsInt(String key, Integer defaultValue) {
        String result = this.get(key);
        return result != null ? NumberUtils.toInt((String)result) : defaultValue;
    }

    public void setObject(final String key, final Object obj, final int expireSecond) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                byte[] keyBytes = key.getBytes();
                byte[] valueBytes = valueSerializer.serialize(obj);
                jedis.set(keyBytes, valueBytes);
                if (expireSecond > 0) {
                    jedis.expire(keyBytes, expireSecond);
                }
            }
        });
    }

    public <T> T getObject(final String key, Class<T> type) {
        return this.execute(new JedisAction<T>(){

            @Override
            public T action(Jedis jedis) {
                byte[] valueBytes = jedis.get(key.getBytes());
                if (valueBytes != null) {
                    return valueSerializer.deserialize(valueBytes);
                }
                return null;
            }
        });
    }

    public void set(final String key, final String value) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.set(key, value);
            }
        });
    }

    public void setex(final String key, final String value, final int seconds) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.setex(key, seconds, value);
            }
        });
    }

    public Boolean setnx(final String key, final String value) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.setnx(key, value) == 1L ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public String getset(final String key, final String value) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.getSet(key, value);
            }
        });
    }

    public Long getsetAsLong(String key, long value) {
        return NumberUtils.toLong((String)this.getset(key, String.valueOf(value)), (long)Long.MAX_VALUE);
    }

    public Boolean setnxex(final String key, final String value, final int seconds) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                String result = jedis.set(key, value, "NX", "EX", seconds);
                return JedisUtils.isStatusOk((String)result);
            }
        });
    }

    public Long incr(final String key) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.incr(key);
            }
        });
    }

    public Long incrBy(final String key, final long increment) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.incrBy(key, increment);
            }
        });
    }

    public Long decr(final String key) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.decr(key);
            }
        });
    }

    public void lpush(final String key, final String ... values) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.lpush(key, values);
            }
        });
    }

    public void rpush(final String key, final String ... values) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.rpush(key, values);
            }
        });
    }

    public void clearList(final String key) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.ltrim(key, 1L, 0L);
            }
        });
    }

    public List<String> getListAllItem(final String key) {
        return this.execute(new JedisAction<List<String>>(){

            @Override
            public List<String> action(Jedis jedis) {
                return jedis.lrange(key, 0L, -1L);
            }
        });
    }

    public String rpop(final String key) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.rpop(key);
            }
        });
    }

    public String lpop(final String key) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.lpop(key);
            }
        });
    }

    public Long llen(final String key) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.llen(key);
            }
        });
    }

    public Boolean lremOne(final String key, final String value) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                Long count = jedis.lrem(key, 1L, value);
                return count == 1L;
            }
        });
    }

    public Boolean lremAll(final String key, final String value) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                Long count = jedis.lrem(key, 0L, value);
                return count > 0L;
            }
        });
    }

    public Boolean zadd(final String key, final String member, final double score) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.zadd(key, score, member) == 1L;
            }
        });
    }

    public Long zmutiadd(final String key, final Map<String, Double> scoreMemberMap) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.zadd(key, scoreMemberMap);
            }
        });
    }

    public boolean hasMemberInzset(final String key, final String member) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                Long index = jedis.zrank(key, member);
                return index != null && index >= 0L;
            }
        });
    }

    public Boolean zrem(final String key, final String member) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.zrem(key, new String[]{member}) == 1L ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public List<String> findAllMemberOfzsetByScoreDesc(final String key) {
        Set<String> memberSet = this.execute(new JedisAction<Set<String>>(){

            @Override
            public Set<String> action(Jedis jedis) {
                return jedis.zrevrangeByScore(key, "+inf", "-inf");
            }
        });
        ArrayList memberList = Collections.emptyList();
        if (!CollectionUtils.isEmpty(memberSet)) {
            memberList = Lists.newArrayList(memberSet.iterator());
        }
        return memberList;
    }

    public boolean zremOfIndexByScoreAsc(String key, long index) {
        return this.zremRangeByScoreAsc(key, index, index) == 1L;
    }

    public Long zremRangeByScoreAsc(final String key, final long startIdx, final long endIndex) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.zremrangeByRank(key, startIdx, endIndex);
            }
        });
    }

    public Double zscore(final String key, final String member) {
        return this.execute(new JedisAction<Double>(){

            @Override
            public Double action(Jedis jedis) {
                return jedis.zscore(key, member);
            }
        });
    }

    public Long zcard(final String key) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.zcard(key);
            }
        });
    }

    public int getDatabase() {
        return this.dbIndex;
    }

    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"invalid DB index (a positive index required)");
        this.dbIndex = index;
    }

    public static interface JedisActionNoResult {
        public void action(Jedis var1);
    }

    public static interface BussiCallback {
        public void doBussiInAction();

        public void rollback();
    }

    public static interface JedisAction<T> {
        public T action(Jedis var1);
    }
}

