/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.redis;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.redisson.Config;
import org.redisson.Redisson;
import org.redisson.SentinelServersConfig;
import org.redisson.SingleServerConfig;
import org.redisson.core.RLock;

public class RedissonTemplate {
    public static final String SCRAPE_LOCK = "scrapeLock";
    public static final String AUCTION_LOCK = "auctionLock";
    public static final String AUCTION_FREEZEN_FETCH_REFUND_DATA_LOCK = "auctionFetchRefundDataLock";
    public static final String AUCTION_USER_OFFER_CENT_DATA_LOCK = "auctionUserOfferCentLock";
    public static final String ORDER_LOCK = "order_lock_";
    public static final String TURNTABLE_LOCK = "TURNTABLE_LOCK";
    public static final String REGISTER_LOCK = "REGISTER_LOCK_";
    public static final String SEC_KILL = "SEC_KILL";
    public static final String SAME_RECORDE = "SAME_RECORDE_";
    private final Redisson rds;
    private final Map<String, RLock> lockMap = new ConcurrentHashMap<String, RLock>();

    public RedissonTemplate(String masterName, int dbIndex, String password, String ... sentinelAddrs) {
        Config config = new Config();
        ((SentinelServersConfig)config.useSentinelConnection().setMasterName(masterName).addSentinelAddress(sentinelAddrs).setDatabase(dbIndex)).setPassword(password);
        this.rds = Redisson.create((Config)config);
    }

    public RedissonTemplate(String address, int dbIndex, int timeout, String password) {
        Config config = new Config();
        ((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setPassword(password)).setDatabase(dbIndex)).setAddress(address).setTimeout(timeout);
        this.rds = Redisson.create((Config)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RLock getDistributeLock(String lockName) {
        RLock lock = this.lockMap.get(lockName);
        if (lock == null) {
            RedissonTemplate redissonTemplate = this;
            synchronized (redissonTemplate) {
                if (lock == null) {
                    lock = this.rds.getLock(lockName);
                }
                this.lockMap.put(lockName, lock);
            }
        }
        return lock;
    }
}

