/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.CartItem;
import com.rocoinfo.rocomall.repository.CartDao;
import com.rocoinfo.rocomall.service.ICartService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springside.modules.utils.Collections3;

@Service
@Transactional
public class CartService
extends CrudService<CartDao, CartItem>
implements ICartService {
    @Override
    public void saveCardItems(CartItem ... items) {
        if (!ArrayUtils.isEmpty((Object[])items)) {
            ((CartDao)this.entityDao).saveCardItems(items);
        }
    }

    @Override
    public List<CartItem> findCheckedCartItemListByUserId(long userId) {
        ArrayList checkedItems = Lists.newArrayList();
        for (CartItem cartItem : this.findCartItemListByUserId(userId)) {
            if (!cartItem.isChecked()) continue;
            checkedItems.add(cartItem);
        }
        return checkedItems;
    }

    @Override
    public List<CartItem> findCartItemListByUserId(long userId) {
        List<CartItem> itemList = Collections.emptyList();
        if (userId > 0L) {
            itemList = ((CartDao)this.entityDao).getCartItemListByUserId(userId);
        }
        return itemList;
    }

    @Override
    public List<CartItem> findCartItemListByUserAndSkuIdsIn(long userId, List<Long> skuIds) {
        ArrayList itemList = Collections.emptyList();
        if (userId > 0L && !CollectionUtils.isEmpty(skuIds)) {
            itemList = Lists.newArrayList();
            List<CartItem> userCartItems = this.findCartItemListByUserId(userId);
            for (CartItem item : userCartItems) {
                if (!skuIds.contains(item.getUnitProdId())) continue;
                itemList.add(item);
            }
        }
        return itemList;
    }

    @Override
    public CartItem getCartItemByUnitProdId(long userId, long unitProdId) {
        CartItem item = null;
        for (CartItem itm : this.findCartItemListByUserId(userId)) {
            if (itm.getUnitProdId() != unitProdId) continue;
            item = itm;
            break;
        }
        return item;
    }

    @Override
    public void removeCartItemUnitProdId(long userId, Long ... unitProdIds) {
        if (!ArrayUtils.isEmpty((Object[])unitProdIds) && userId > 0L) {
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)1);
            paramMap.put("unitProdIds", unitProdIds);
            paramMap.put("userId", userId);
            ((CartDao)this.entityDao).removeCartItem(paramMap);
        }
    }

    @Override
    public void clearCartByUserId(long userId) {
        if (userId > 0L) {
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)1);
            paramMap.put("userId", userId);
            ((CartDao)this.entityDao).removeCartItem(paramMap);
        }
    }

    @Override
    public void modifyCardItemQuantity(CartItem cartItem) {
        if (cartItem != null) {
            ((CartDao)this.entityDao).modifyCardItemQuantity(cartItem);
        }
    }

    @Override
    public void updateCartItemCheckedIn(long userId, List<Long> checkedSkuIdList) {
        if (userId > 0L && !CollectionUtils.isEmpty(checkedSkuIdList)) {
            String checkedSkuIds = Collections3.convertToString(checkedSkuIdList, (String)",");
            ((CartDao)this.entityDao).updateCartItemCheckedIn(userId, checkedSkuIds);
        }
    }

    @Override
    public void batchModifyCartItemQtMap(Map<Long, Integer> cartItemQtMap) {
        if (!CollectionUtils.isEmpty(cartItemQtMap)) {
            ArrayList itemIdList = Lists.newArrayListWithExpectedSize((int)cartItemQtMap.size());
            ArrayList quantityList = Lists.newArrayListWithExpectedSize((int)cartItemQtMap.size());
            for (Long itemId : cartItemQtMap.keySet()) {
                itemIdList.add(itemId);
                quantityList.add(cartItemQtMap.get(itemId));
            }
            ((CartDao)this.entityDao).batchModifyCartItemQts(itemIdList, quantityList);
        }
    }

    @Override
    public Map<Long, Integer> dbCartItemMap(Long loggedUserId) {
        LinkedHashMap itemQtMap = Maps.newLinkedHashMap();
        if (null == loggedUserId) {
            return itemQtMap;
        }
        List<CartItem> cartItemList = this.findCartItemListByUserId(loggedUserId);
        for (CartItem item : cartItemList) {
            long skuId = item.getUnitProdId();
            int quantity = item.getQuantity();
            itemQtMap.put(skuId, quantity);
        }
        return itemQtMap;
    }
}

