/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl;

import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.cfg.Config;
import com.rocoinfo.rocomall.repository.cfg.ConfigDao;
import com.rocoinfo.rocomall.service.cfg.IConfigService;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springside.modules.utils.Collections3;

@Service
public class ConfigService
extends CrudService<ConfigDao, Config>
implements IConfigService {
    @Override
    public Config getByKey(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        ServletContext servletCtx = PropertyHolder.getServletContext();
        Config config = (Config)servletCtx.getAttribute(key);
        if (config != null) {
            return config;
        }
        Config cfg = ((ConfigDao)this.entityDao).getByKey(key);
        if (cfg != null) {
            servletCtx.setAttribute(key, (Object)cfg);
        }
        return cfg;
    }

    @Override
    public void clearServletCtxCachedConfig(String ... keys) {
        if (keys != null && keys.length > 0) {
            ServletContext servletCtx = PropertyHolder.getServletContext();
            for (String key : keys) {
                servletCtx.removeAttribute(key);
            }
        }
    }

    @Override
    public void deleteByKeys(String ... keys) {
        if (ArrayUtils.isNotEmpty((Object[])keys)) {
            ((ConfigDao)this.entityDao).deleteByKeys(keys);
        }
    }

    @Override
    @Transactional
    public void batchUpdate(List<Config> configList) {
        if (CollectionUtils.isNotEmpty(configList)) {
            List keyList = Collections3.extractToList(configList, (String)"key");
            this.deleteByKeys(keyList.toArray(new String[0]));
            for (Config cfg : configList) {
                ((ConfigDao)this.entityDao).insert(cfg);
            }
        }
    }
}

