/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.ProductSpecial;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.repository.ProductSpecialDao;
import com.rocoinfo.rocomall.service.IProductSpecialService;
import com.rocoinfo.rocomall.service.product.ICatalogService;
import com.rocoinfo.rocomall.service.product.ISkuService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductSpecialService
extends CrudService<ProductSpecialDao, ProductSpecial>
implements IProductSpecialService {
    @Autowired
    private ISkuService skuService;
    @Autowired
    private ICatalogService catalogService;

    @Override
    public void buildDetail(ProductSpecial productSpecial) {
        Sku sku = (Sku)this.skuService.getById(productSpecial.getSku().getId());
        this.skuService.buildDetail(sku);
        productSpecial.setSku(sku);
    }

    @Override
    public ListMultimap<String, ProductSpecial> findSettingProductListMap(long catalogId, IProductSpecialService.ProductSpecialQueryParam ... typeCodeParams) {
        ArrayListMultimap settingProdListMap = ArrayListMultimap.create();
        if (ArrayUtils.isNotEmpty((Object[])typeCodeParams)) {
            HashMap paramMap = Maps.newHashMap();
            if (catalogId != 0L) {
                paramMap.put("cid", catalogId);
            }
            paramMap.put("specialTypes", typeCodeParams);
            List<ProductSpecial> specialProdList = ((ProductSpecialDao)this.entityDao).findSettingProdListByCateIdAndTypeCode(paramMap);
            if (!CollectionUtils.isEmpty(specialProdList)) {
                ArrayList skuList = Lists.newArrayListWithExpectedSize((int)specialProdList.size());
                for (ProductSpecial specialProd : specialProdList) {
                    settingProdListMap.put((Object)specialProd.getType().getCode(), (Object)specialProd);
                    skuList.add(specialProd.getSku());
                }
                this.skuService.loadImages(skuList);
            }
        }
        return settingProdListMap;
    }

    @Override
    public List<ProductSpecial> findProdSepecialByParams(Map<String, Object> params) {
        return ((ProductSpecialDao)this.entityDao).findProdSepecialByParams(params);
    }
}

