/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.activity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.activity.Activity;
import com.rocoinfo.rocomall.entity.activity.ActivitySku;
import com.rocoinfo.rocomall.repository.activity.ActivitySkuDao;
import com.rocoinfo.rocomall.service.activity.IActivityService;
import com.rocoinfo.rocomall.service.activity.IActivitySkuService;
import com.rocoinfo.rocomall.service.product.ISkuService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
@Transactional
public class ActivitySkuService
extends CrudService<ActivitySkuDao, ActivitySku>
implements IActivitySkuService {
    @Autowired
    private ActivitySkuDao activitySkuDao;
    @Autowired
    private ISkuService skuService;
    @Autowired
    private IActivityService activityService;

    @Override
    public void insert(ActivitySku activitySku) {
        this.activitySkuDao.insert(activitySku);
    }

    @Override
    public List<ActivitySku> findByActivityId(Long activityId) {
        return this.activitySkuDao.getByActivityId(activityId);
    }

    @Override
    public Map<Long, List<ActivitySku>> findListMapByActivityIdIn(List<Long> actIdList) {
        List<ActivitySku> activitySkuList = this.activitySkuDao.findWithSkuDetailByActivityIdIn(actIdList);
        if (CollectionUtils.isEmpty(activitySkuList)) {
            return Collections.emptyMap();
        }
        HashMap actSkuListMap = Maps.newHashMap();
        for (ActivitySku actSku : activitySkuList) {
            Long actId = actSku.getActivity().getId();
            List actSkuList = (List)actSkuListMap.get(actId);
            if (actSkuList == null) {
                actSkuList = Lists.newArrayList();
                actSkuListMap.put(actId, actSkuList);
            }
            actSkuList.add(actSku);
        }
        return actSkuListMap;
    }

    public List<Long> findActivityIdBySkuIdAndActivityStatus(Long skuId, Activity.Status status) {
        return this.activitySkuDao.findActivityIdBySkuIdAndActivityStatus(skuId, status);
    }

    @Override
    public void deleteByActivityId(Long activityId) {
        this.activitySkuDao.deleteByActivityId(activityId);
    }

    public List<ActivitySku> findDetailByActivityId(Long activityId) {
        List<ActivitySku> activitySkus = this.findByActivityId(activityId);
        if (!CollectionUtils.isEmpty(activitySkus)) {
            Activity act = (Activity)this.activityService.getById(activityId);
            for (ActivitySku activitySku : activitySkus) {
                activitySku.setSku((Sku)this.skuService.getById(activitySku.getSku().getId()));
                this.skuService.buildDetail(activitySku.getSku());
                activitySku.setActivity(act);
            }
        }
        return activitySkus;
    }

    public List<Long> findListedActivityIdBySkuId(Long skuId) {
        return this.activitySkuDao.findListedActivityIdBySkuId(skuId);
    }

    public List<Long> findListedActivityIdBySkuIdIn(List<Long> skuIds) {
        return this.activitySkuDao.findListedActivityIdBySkuIdIn(skuIds);
    }

    @Override
    public List<Long> findProductIdByActivityId(Long activityId) {
        return this.activitySkuDao.findProductIdByActivityId(activityId);
    }

    public List<ActivitySku> getSkusByActivityId(Long activityId) {
        return this.activitySkuDao.getSkusByActivityId(activityId);
    }

    public Long getTotalCentByActivityId(Long activityId) {
        return this.activitySkuDao.getTotalCentByActivityId(activityId);
    }

    public void increaseHitNumById(Long id) {
        this.activitySkuDao.increaseHitNumById(id);
    }

    @Override
    public List<Activity> getExclusiveActivityCountByskuId(Long skuId) {
        return this.activitySkuDao.getExclusiveActivityCountByskuId(skuId);
    }
}

