/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.cent;

import com.rocoinfo.rocomall.entity.cent.CentApply;
import com.rocoinfo.rocomall.entity.cent.CentApplyDetail;
import com.rocoinfo.rocomall.entity.cent.CentApprove;
import com.rocoinfo.rocomall.entity.cent.Cents;
import com.rocoinfo.rocomall.repository.cent.CentApplyDao;
import com.rocoinfo.rocomall.repository.cent.CentApplyDetailDao;
import com.rocoinfo.rocomall.repository.cent.CentApproveDao;
import com.rocoinfo.rocomall.repository.cent.CentsDao;
import com.rocoinfo.rocomall.service.impl.cent.CentBudgetService;
import com.rocoinfo.rocomall.utils.CodeGenerator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springside.modules.utils.Collections3;

@Service
@Transactional
public class CentImportService {
    @Autowired
    private CentApplyDao centApplyDao;
    @Autowired
    private CentApplyDetailDao centApplyDetailDao;
    @Autowired
    private CentApproveDao centApproveDao;
    @Autowired
    private CentsDao centsDao;
    @Autowired
    private CentBudgetService centBudgetService;
    @Autowired
    private CodeGenerator codeGenerator;
    private static final int INSERT_MAX_RECORD = 1000;

    public CentApply getCentApplyById(Long id) {
        return null;
    }

    public List<CentApplyDetail> findCentDetailInfoByApplyId(Long applyId) {
        return this.centApplyDetailDao.findCentDetailInfoByApplyId(applyId);
    }

    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void deleteCentDetailById(CentApplyDetail centApplyDetail) throws Exception {
        CentApplyDetail queryCentApplyDetail = (CentApplyDetail)this.centApplyDetailDao.getById(centApplyDetail.getId());
        CentApply queryCentApply = (CentApply)this.centApplyDao.getById(queryCentApplyDetail.getApplyId());
        this.centApplyDetailDao.deleteById(centApplyDetail.getId());
        if (CentApply.Type.ADD.equals((Object)queryCentApply.getType())) {
            Cents cents = new Cents();
            cents.setStatus(Cents.Status.CANUSE);
            cents.setCode(queryCentApplyDetail.getCentCode());
            this.centsDao.update(cents);
        }
    }

    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void deleteCentApplyAllInfoById(Long id) throws Exception {
        CentApply queryCentApply = (CentApply)this.centApplyDao.getById(id);
        if (CentApply.Type.ADD.equals((Object)queryCentApply.getType())) {
            List<CentApplyDetail> centApplyDetails = this.centApplyDetailDao.findCentDetailInfoByApplyId(id);
            for (CentApplyDetail centApplyDetail : centApplyDetails) {
                Cents cents = new Cents();
                cents.setStatus(Cents.Status.CANUSE);
                cents.setCode(centApplyDetail.getCentCode());
                this.centsDao.update(cents);
            }
        }
        this.centApplyDao.deleteById(id);
        this.centApplyDetailDao.deleteByApplyId(id);
    }

    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void updateApplyInfo(CentApply centApply) throws Exception {
        this.centApplyDao.update(centApply);
    }

    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void updateCentSubstractInfo(CentApply centApply) throws Exception {
        this.centApplyDao.update(centApply);
    }

    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void updateApplyAddInfo(CentApplyDetail postdata) throws Exception {
        CentApply centApply = new CentApply();
        centApply.setId(postdata.getApplyId());
        this.centApplyDao.update(centApply);
        this.centApplyDetailDao.update(postdata);
    }

    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void submitAudit(CentApply centApply) throws Exception {
        this.centApplyDao.update(centApply);
    }

    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void denyAudit(CentApprove centApprove) throws Exception {
        CentApply updateApplyState = new CentApply();
        this.centApproveDao.insert(centApprove);
        this.centApplyDao.update(updateApplyState);
        CentApply centApply = (CentApply)this.centApplyDao.getById(updateApplyState.getId());
        if (CentApply.Type.ADD.equals((Object)centApply.getType())) {
            List<CentApplyDetail> centApplyDetails = this.centApplyDetailDao.findCentDetailInfoByApplyId(updateApplyState.getId());
            this.centsDao.batchModifyCentStatus(Cents.Status.CANUSE, Collections3.extractToList(centApplyDetails, (String)"centCode"));
        }
    }

    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void returnAudit(CentApprove centApprove) throws Exception {
        this.centApproveDao.insert(centApprove);
        CentApply centApply = new CentApply();
        this.centApplyDao.update(centApply);
    }

    public CentApply getByApplyCode(String applyCode) {
        return null;
    }
}

