/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.cfg;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.cent.CentRule;
import com.rocoinfo.rocomall.entity.cfg.SigninRecord;
import com.rocoinfo.rocomall.entity.cfg.SigninRuleCfg;
import com.rocoinfo.rocomall.repository.cfg.SigninRecordDao;
import com.rocoinfo.rocomall.service.cent.ICentRuleService;
import com.rocoinfo.rocomall.service.cfg.ISigninRecordService;
import com.rocoinfo.rocomall.service.cfg.ISigninRuleCfgService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SigninRecordService
extends CrudService<SigninRecordDao, SigninRecord>
implements ISigninRecordService {
    @Autowired
    private ISigninRuleCfgService signRuleService;
    @Autowired
    private ICentRuleService centRuleService;

    public SigninRecord getLastSignRecordByUserId(Long userId) {
        return ((SigninRecordDao)this.entityDao).getLastSignRecordByUserId(userId);
    }

    @Override
    @Transactional
    public void insert(SigninRecord record) {
        super.insert(record);
        SigninRuleCfg signRule = this.signRuleService.getUniqueSigninRule();
        int signDays = record.getContinueSignDay() % signRule.getDayCycle();
        CentRule centRule = null;
        List<SigninRuleCfg.CentCfgItem> itemList = signRule.getCfgItemList();
        for (SigninRuleCfg.CentCfgItem item : itemList) {
            if (item.getDay() != signDays) continue;
            centRule = (CentRule)this.centRuleService.getById(item.getRule().getId());
            break;
        }
        if (!centRule.isUsable() || centRule.getCent() > 0) {
            // empty if block
        }
    }
}

