/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.dict;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.dict.DictPlatform;
import com.rocoinfo.rocomall.repository.dict.DictPlatformDao;
import com.rocoinfo.rocomall.service.IUploadService;
import com.rocoinfo.rocomall.service.dict.IDictPlatformService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictPlatformService
extends CrudService<DictPlatformDao, DictPlatform>
implements IDictPlatformService {
    @Autowired
    private IUploadService uploadService;

    public DictPlatform getPlatformByCode(String code) {
        DictPlatform platform = null;
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            for (DictPlatform pla : super.findAll()) {
                if (pla == null || !pla.getCode().equals(code)) continue;
                platform = pla;
                break;
            }
        }
        return platform;
    }

    @Override
    public void insert(DictPlatform platform) {
        if (platform != null) {
            if (StringUtils.isNotBlank((CharSequence)platform.getIconPath())) {
                platform.setIconPath(this.uploadService.submitPath(platform.getIconPath()));
            }
            super.insert(platform);
        }
    }

    @Override
    public void update(DictPlatform platform) {
        if (platform != null) {
            DictPlatform oldPlatform;
            if (platform.getIconPath() != null && StringUtils.isNotBlank((CharSequence)(oldPlatform = (DictPlatform)super.getById(platform.getId())).getIconPath()) && !oldPlatform.getIconPath().equals(platform.getIconPath())) {
                platform.setIconPath(this.uploadService.submitPath(platform.getIconPath()));
                this.uploadService.delete(oldPlatform.getIconPath());
            }
            super.update(platform);
        }
    }

    @Override
    public boolean isExistName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return false;
        }
        for (DictPlatform pla : super.findAll()) {
            if (pla == null || !pla.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExistCode(String platformCode) {
        if (StringUtils.isBlank((CharSequence)platformCode)) {
            return false;
        }
        for (DictPlatform pla : super.findAll()) {
            if (pla == null || !pla.getCode().equalsIgnoreCase(platformCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<DictPlatform> findByVisibility(Boolean visibility) {
        List<DictPlatform> all = this.findAll();
        if (visibility == null) {
            return all;
        }
        ArrayList<DictPlatform> filterDictPlats = new ArrayList<DictPlatform>();
        for (DictPlatform advType : all) {
            if (!advType.getVisiable().equals(visibility)) continue;
            filterDictPlats.add(advType);
        }
        return filterDictPlats;
    }
}

