/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.dict;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.dict.DictWarehouse;
import com.rocoinfo.rocomall.enumconst.Status;
import com.rocoinfo.rocomall.repository.dict.DictWarehouseDao;
import com.rocoinfo.rocomall.service.dict.IDictWarehouseService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.cache.Cache;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class DictWarehouseService
extends CrudService<DictWarehouseDao, DictWarehouse>
implements IDictWarehouseService {
    @Override
    protected void evictCacheEntitysHook() {
        String allCatalogCacheKey = StringUtils.substringBetween((String)"'cache.dict.warehouse.all'", (String)"'");
        Cache cache = this.cacheManager.getCache("cache");
        cache.evict((Object)allCatalogCacheKey);
    }

    @Override
    @Cacheable(value={"cache"}, key="'cache.dict.warehouse.all'", unless="#result==null || #result.isEmpty()")
    public List<DictWarehouse> findAll() {
        return super.findAll();
    }

    @Override
    public Map<Long, DictWarehouse> findAllWarehouseMap() {
        LinkedHashMap warehouseMap = Maps.newLinkedHashMap();
        List<DictWarehouse> allWarehouse = this.getProxy().findAll();
        if (CollectionUtils.isNotEmpty(allWarehouse)) {
            for (DictWarehouse exp : allWarehouse) {
                warehouseMap.put(exp.getId(), exp);
            }
        }
        return warehouseMap;
    }

    @Override
    public boolean isExistCode(String warehouseCode) {
        if (StringUtils.isBlank((CharSequence)warehouseCode)) {
            return false;
        }
        for (DictWarehouse exp : this.getProxy().findAll()) {
            if (exp == null || !exp.getCode().equalsIgnoreCase(warehouseCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExistName(String warehouseName) {
        if (StringUtils.isBlank((CharSequence)warehouseName)) {
            return false;
        }
        for (DictWarehouse exp : this.getProxy().findAll()) {
            if (exp == null || !exp.getName().equalsIgnoreCase(warehouseName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, DictWarehouse> findWarehouseMapByCodesIn(List<String> warehouseCodes) {
        HashMap expressMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(warehouseCodes)) {
            for (DictWarehouse exp : this.getProxy().findAll()) {
                if (exp == null || !warehouseCodes.contains(exp.getCode())) continue;
                expressMap.put(exp.getCode(), exp);
            }
        }
        return expressMap;
    }

    private DictWarehouseService getProxy() {
        return (DictWarehouseService)AopContext.currentProxy();
    }

    @Override
    public void insert(DictWarehouse warehouse) {
        if (this.isExistCode(warehouse.getCode())) {
            throw new ServiceException("\u5feb\u9012\u516c\u53f8\u7f16\u53f7\u5df2\u5b58\u5728");
        }
        if (this.isExistName(warehouse.getName())) {
            throw new ServiceException("\u5feb\u9012\u516c\u53f8\u540d\u79f0\u5df2\u5b58\u5728");
        }
        super.insert(warehouse);
    }

    @Override
    public void update(DictWarehouse warehouse) {
        DictWarehouse oldWarehouse = (DictWarehouse)this.getById(warehouse.getId());
        if (!oldWarehouse.getName().equalsIgnoreCase(warehouse.getName()) && this.isExistName(warehouse.getName())) {
            throw new ServiceException("\u5feb\u9012\u516c\u53f8\u540d\u79f0\u5df2\u5b58\u5728,\u8bf7\u6362\u4e2a\u540d\u79f0");
        }
        super.update(warehouse);
    }

    @Override
    public List<DictWarehouse> findAllWithStatus(Status state) {
        List<DictWarehouse> all = this.getProxy().findAll();
        if (state == null) {
            return all;
        }
        ArrayList<DictWarehouse> opens = new ArrayList<DictWarehouse>();
        ArrayList<DictWarehouse> locks = new ArrayList<DictWarehouse>();
        for (DictWarehouse advType : all) {
            if (advType.getState() == Status.OPEN) {
                opens.add(advType);
                continue;
            }
            locks.add(advType);
        }
        if (state == Status.OPEN) {
            return opens;
        }
        return locks;
    }
}

