/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.dict.express;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.dict.DictProviceCity;
import com.rocoinfo.rocomall.entity.dict.express.DictExpress;
import com.rocoinfo.rocomall.enumconst.Status;
import com.rocoinfo.rocomall.repository.dict.express.DictExpressDao;
import com.rocoinfo.rocomall.service.dict.express.IDictExpressService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.cache.Cache;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class DictExpressService
extends CrudService<DictExpressDao, DictExpress>
implements IDictExpressService {
    @Override
    public Collection<DictExpress> findAllOpenedExpress() {
        ArrayList openedList = Lists.newArrayList();
        for (DictExpress express : this.findAllExpressMap().values()) {
            if (express.getStatus() != Status.OPEN) continue;
            openedList.add(express);
        }
        return openedList;
    }

    @Override
    protected void evictCacheEntitysHook() {
        String allCatalogCacheKey = StringUtils.substringBetween((String)"'cache.dict.express.all'", (String)"'");
        Cache cache = this.cacheManager.getCache("cache");
        cache.evict((Object)allCatalogCacheKey);
    }

    @Override
    @Cacheable(value={"cache"}, key="'cache.dict.express.all'", unless="#result==null || #result.isEmpty()")
    public List<DictExpress> findAll() {
        return super.findAll();
    }

    @Override
    public Map<Long, DictExpress> findAllExpressMap() {
        LinkedHashMap expressMap = Maps.newLinkedHashMap();
        List<DictExpress> allExpress = this.getProxy().findAll();
        if (CollectionUtils.isNotEmpty(allExpress)) {
            for (DictExpress exp : allExpress) {
                expressMap.put(exp.getId(), exp);
            }
        }
        return expressMap;
    }

    @Override
    public boolean isExistCode(String expressCode) {
        if (StringUtils.isBlank((CharSequence)expressCode)) {
            return false;
        }
        for (DictExpress exp : this.getProxy().findAll()) {
            if (exp == null || !exp.getCode().equalsIgnoreCase(expressCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExistName(String expressName) {
        if (StringUtils.isBlank((CharSequence)expressName)) {
            return false;
        }
        for (DictExpress exp : this.getProxy().findAll()) {
            if (exp == null || !exp.getName().equalsIgnoreCase(expressName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, DictExpress> findExpressMapByCodesIn(List<String> expressCodes) {
        HashMap expressMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(expressCodes)) {
            for (DictExpress exp : this.getProxy().findAll()) {
                if (exp == null || !expressCodes.contains(exp.getCode())) continue;
                expressMap.put(exp.getCode(), exp);
            }
        }
        return expressMap;
    }

    private DictExpressService getProxy() {
        return (DictExpressService)AopContext.currentProxy();
    }

    @Override
    public void insert(DictExpress express) {
        if (this.isExistCode(express.getCode())) {
            throw new ServiceException("\u5feb\u9012\u516c\u53f8\u7f16\u53f7\u5df2\u5b58\u5728");
        }
        if (this.isExistName(express.getName())) {
            throw new ServiceException("\u5feb\u9012\u516c\u53f8\u540d\u79f0\u5df2\u5b58\u5728");
        }
        super.insert(express);
    }

    @Override
    public void update(DictExpress express) {
        DictExpress oldExpress = (DictExpress)this.getById(express.getId());
        if (!oldExpress.getName().equalsIgnoreCase(express.getName()) && this.isExistName(express.getName())) {
            throw new ServiceException("\u5feb\u9012\u516c\u53f8\u540d\u79f0\u5df2\u5b58\u5728,\u8bf7\u6362\u4e2a\u540d\u79f0");
        }
        super.update(express);
    }

    @Override
    public List<DictExpress> findAllWithStatus(Status status) {
        List<DictExpress> all = this.getProxy().findAll();
        if (status == null) {
            return all;
        }
        ArrayList<DictExpress> opens = new ArrayList<DictExpress>();
        ArrayList<DictExpress> locks = new ArrayList<DictExpress>();
        for (DictExpress advType : all) {
            if (advType.getStatus() == Status.OPEN) {
                opens.add(advType);
                continue;
            }
            locks.add(advType);
        }
        if (status == Status.OPEN) {
            return opens;
        }
        return locks;
    }

    @Override
    @Deprecated
    public List<DictProviceCity> findAllCityById(Long id) {
        if (id == null) {
            throw new ServiceException("\u5feb\u9012\u516c\u53f8Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ((DictExpressDao)this.entityDao).findAllCityById(id);
    }

    @Override
    public List<Long> findBoundedCityIdsById(Long id) {
        if (id == null || id < 1L) {
            return Collections.emptyList();
        }
        return ((DictExpressDao)this.entityDao).findBoundedCityIdsById(id);
    }

    @Override
    public DictExpress findBoundExpressByCityId(Long cityId) {
        List<DictProviceCity> expCityList = this.findCityExpressByBoundedCityIds(Lists.newArrayList((Object[])new Long[]{cityId}));
        if (CollectionUtils.isNotEmpty(expCityList)) {
            return expCityList.get(0).getExpress();
        }
        return null;
    }

    @Override
    public List<DictProviceCity> findCityExpressByBoundedCityIds(List<Long> cityIds) {
        if (CollectionUtils.isEmpty(cityIds)) {
            return Collections.emptyList();
        }
        return ((DictExpressDao)this.entityDao).findCityExpressByBoundedCityIds(cityIds);
    }

    @Override
    public void updateCitys(DictExpress express) {
        if (express == null || express.getId() == null) {
            throw new ServiceException("\u5feb\u9012\u516c\u53f8Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ((DictExpressDao)this.entityDao).deleteAllCitysById(express.getId());
        if (express.getCitys() != null && express.getCitys().size() > 0) {
            ((DictExpressDao)this.entityDao).insertCitys(express);
        }
    }
}

