/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.dict.express;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.dict.express.ExpressFeeItem;
import com.rocoinfo.rocomall.entity.dict.express.FeeItemCity;
import com.rocoinfo.rocomall.repository.dict.express.ExpressFeeItemDao;
import com.rocoinfo.rocomall.service.dict.express.IExpressFeeItemService;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springside.modules.utils.Collections3;

@Service
public class ExpressFeeItemService
extends CrudService<ExpressFeeItemDao, ExpressFeeItem>
implements IExpressFeeItemService {
    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void insert(ExpressFeeItem feeItem) {
        if (feeItem != null) {
            super.insert(feeItem);
            if (CollectionUtils.isNotEmpty(feeItem.getItemCitys())) {
                for (FeeItemCity itemCity : feeItem.getItemCitys()) {
                    itemCity.setFeeItemId(feeItem.getId());
                }
                ((ExpressFeeItemDao)this.entityDao).saveItemCitys(feeItem.getItemCitys());
            }
        }
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void deleteFeeItemsByTemplateId(long templateId) {
        List<ExpressFeeItem> itemList;
        if (templateId > 0L && CollectionUtils.isNotEmpty(itemList = ((ExpressFeeItemDao)this.entityDao).findItemsByTemplateId(templateId))) {
            ((ExpressFeeItemDao)this.entityDao).deleteItemsByTemplateId(templateId);
            List itemIdList = Collections3.extractToList(itemList, (String)"id");
            ((ExpressFeeItemDao)this.entityDao).deleteItemCitysByItemIds(itemIdList);
        }
    }

    @Override
    public ExpressFeeItem getFeeItemByCityIdAndExpressId(Long cityId, Long expressId) {
        return ((ExpressFeeItemDao)this.entityDao).getFeeItemByCityIdAndExpressId(cityId, expressId);
    }
}

