/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.order;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.dto.admin.OrderDetailsDto;
import com.rocoinfo.rocomall.dto.admin.OrderListDto;
import com.rocoinfo.rocomall.entity.Address;
import com.rocoinfo.rocomall.entity.ProductImage;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.order.Order;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.entity.params.OrderParams;
import com.rocoinfo.rocomall.repository.OrderItemOperationLogDao;
import com.rocoinfo.rocomall.repository.order.OrderDao;
import com.rocoinfo.rocomall.repository.order.OrderItemDao;
import com.rocoinfo.rocomall.service.IUserService;
import com.rocoinfo.rocomall.service.impl.AddressService;
import com.rocoinfo.rocomall.service.order.INewOrderService;
import com.rocoinfo.rocomall.service.order.IOrderItemService;
import com.rocoinfo.rocomall.service.order.IOrderService;
import com.rocoinfo.rocomall.service.product.IProductImageService;
import com.rocoinfo.rocomall.service.product.ISkuService;
import com.rocoinfo.rocomall.utils.CodeGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springside.modules.utils.Collections3;

@Service
public class NewOrderService
extends CrudService<OrderDao, Order>
implements INewOrderService {
    @Autowired
    private AddressService addressService;
    @Autowired
    private ISkuService skuService;
    @Autowired
    private IUserService userService;
    @Autowired
    private CodeGenerator codeGenerator;
    @Autowired
    private OrderDao orderDao;
    @Autowired
    private OrderItemDao orderItemDao;
    @Autowired
    private IOrderItemService orderItemService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IProductImageService productImageService;
    @Autowired
    private OrderItemOperationLogDao operLogDao;

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public Object createOrder(OrderParams orderParams) {
        User user = (User)this.userService.getById(orderParams.getUserId());
        if (user == null) {
            return StatusDto.buildFailureStatusDto("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        Sku sku = this.skuService.buildDetail(orderParams.getSkuId(), false);
        if (!this.isCanBuy(sku, orderParams.getQuantity())) {
            return StatusDto.buildFailureStatusDto("\u8be5\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff01");
        }
        Address address = null;
        if (!orderParams.getIsInvite().booleanValue() && (address = (Address)this.addressService.getById(orderParams.getAddressId())) == null) {
            return StatusDto.buildFailureStatusDto("\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Order order = this.buildOrder(user, sku, orderParams);
        OrderItem orderItem = this.buildOrderItem(sku, order, orderParams.getQuantity());
        order.setItems(Lists.newArrayList((Object[])new OrderItem[]{orderItem}));
        this.insert(order);
        HashMap<String, Long> orderInfo = new HashMap<String, Long>();
        orderInfo.put("orderId", order.getId());
        return StatusDto.buildDataSuccessStatusDto("\u64cd\u4f5c\u6210\u529f\uff01", orderInfo);
    }

    private OrderItem buildOrderItem(Sku sku, Order order, int quantity) {
        OrderItem orderItem = new OrderItem();
        orderItem.setOrderCode(order.getOrderCode());
        orderItem.setOrder(order);
        orderItem.setSku(sku);
        orderItem.setUser(order.getUser());
        orderItem.setOrderType(OrderItem.OrderType.common);
        orderItem.setPrice(sku.getCashAmt());
        orderItem.setQuantity(quantity);
        orderItem.setAttributes(this.buildAttributes(sku));
        orderItem.setStatus(OrderItem.Status.NOT_PAID);
        orderItem.setAdmStatus(OrderItem.AdmStatus.NOT_PAID);
        orderItem.setSupplier(sku.getProduct().getSupplier());
        orderItem.setProductName(sku.getProduct().getName());
        orderItem.setCreateTime(new Date());
        return orderItem;
    }

    private String buildAttributes(Sku sku) {
        String attribute3;
        String attribute2;
        StringBuffer attributes = new StringBuffer();
        String attribute = sku.getAttribute1();
        if (StringUtils.isNotEmpty((CharSequence)attribute)) {
            attributes.append(attribute).append(" ");
        }
        if (StringUtils.isNotEmpty((CharSequence)(attribute2 = sku.getAttribute2()))) {
            attributes.append(attribute2).append(" ");
        }
        if (StringUtils.isNotEmpty((CharSequence)(attribute3 = sku.getAttribute3()))) {
            attributes.append(attribute3).append(" ");
        }
        return attributes.toString();
    }

    private Order buildOrder(User user, Sku sku, OrderParams orderParams) {
        Order order = new Order();
        order.setIsInvite(orderParams.getIsInvite());
        order.setAddressId(orderParams.getAddressId());
        order.setUser(user);
        order.setCreateTime(new Date());
        order.setOrderCode(this.codeGenerator.generateOrderCode(new Date(), OrderItem.OrderType.common));
        order.setDeliverFee(orderParams.getCost());
        if (orderParams.getCost() != null) {
            order.setCashAmt(sku.getCashAmt() * (double)orderParams.getQuantity().intValue() + orderParams.getCost());
        } else {
            order.setCashAmt(sku.getCashAmt() * (double)orderParams.getQuantity().intValue());
        }
        order.setCreateTime(new Date());
        order.setOrderCode(this.codeGenerator.generateOrderCode(new Date(), OrderItem.OrderType.common));
        order.setDistributed(false);
        order.setLocked(false);
        order.setCashPayed(true);
        order.setCent(0);
        order.setCentPayed(false);
        order.setNote(orderParams.getNote());
        return order;
    }

    private boolean isCanBuy(Sku sku, Integer quantity) {
        if (sku == null) {
            return false;
        }
        return sku.getAvailableStockQuantity() >= quantity;
    }

    @Override
    public void insert(Order order) {
        super.insert(order);
        order.setId(this.orderDao.getByOrderNo(order.getOrderCode()).getId());
        String consumeTypeCode = OrderItem.OrderType.common.getCode();
        if (!CollectionUtils.isEmpty(order.getItems())) {
            consumeTypeCode = ((OrderItem)Collections3.getFirst(order.getItems())).getOrderType().getCode();
            int i = 0;
            for (OrderItem item : order.getItems()) {
                item.setOrderCode(order.getOrderCode() + "0" + ++i);
                this.orderItemService.insert(item);
            }
            ArrayList skuIdList = Lists.newArrayList();
            ArrayList qtyList = Lists.newArrayList();
            for (OrderItem item : order.getItems()) {
                skuIdList.add(item.getSku().getId());
                qtyList.add(item.getQuantity());
            }
            this.skuService.batchIncreaseOccupiedStockAndSaleVolumeOnPayed(skuIdList, qtyList);
        }
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public Object payOrder(OrderParams orderParams) {
        Order order = (Order)this.orderService.getById(orderParams.getOrderId());
        order.setItems(this.orderItemService.findByOrderId(order.getId()));
        for (OrderItem item : order.getItems()) {
            if (OrderItem.Status.NOT_PAID.equals((Object)item.getStatus())) continue;
            return StatusDto.buildFailureStatusDto("\u8be5\u8ba2\u5355\u4e0d\u80fd\u652f\u4ed8\uff01");
        }
        this.payOrder(order, orderParams);
        return StatusDto.buildDataSuccessStatusDto("\u64cd\u4f5c\u6210\u529f\uff01");
    }

    private void payOrder(Order order, OrderParams orderParams) {
        order.setCashPayType(orderParams.getPaymode());
        order.setPayedTime(new Date());
        this.orderService.update(order);
        for (OrderItem item : order.getItems()) {
            item.setStatus(OrderItem.Status.PAID);
            item.setAdmStatus(OrderItem.AdmStatus.PAID);
            this.orderItemService.update(item);
        }
    }

    @Override
    public Object findOrderItemList(PageRequest pageable, Long userId, String status) {
        OrderItem.Status orderStatus = null;
        if (!StringUtils.isEmpty((CharSequence)status) && (orderStatus = this.inStatus(status)) == null) {
            return StatusDto.buildFailureStatusDto("\u60a8\u67e5\u8be2\u8ba2\u5355\u72b6\u6001\u6709\u8bef\uff01");
        }
        HashMap params = Maps.newHashMap();
        params.put("status", orderStatus);
        params.put("userId", userId);
        params.put("statusList", OrderItem.userCanSeeStatus);
        List<Object> items = Lists.newArrayList();
        long total = this.orderItemDao.searchTotal(params);
        if (total > (long)pageable.getOffset()) {
            params.put("offset", pageable.getOffset());
            params.put("pageSize", pageable.getPageSize());
            params.put("sort", pageable.getSort());
            items = this.orderItemDao.search(params);
        }
        ArrayList orderListDto = Lists.newArrayList();
        for (OrderItem item : items) {
            OrderListDto orderDto = this.buildOrderDtoList(item);
            orderListDto.add(orderDto);
        }
        return StatusDto.buildDataSuccessStatusDto("\u83b7\u53d6\u5217\u8868\u6210\u529f\uff01", new PageImpl((List)orderListDto, (Pageable)pageable, total));
    }

    private OrderListDto buildOrderDtoList(OrderItem item) {
        Long skuId = item.getSku().getId();
        Sku sku = (Sku)this.skuService.getById(skuId);
        List<ProductImage> productImages = this.productImageService.getProductPrimaryImages(sku.getProduct().getId());
        String prodImage = "";
        if (productImages != null && productImages.size() > 0) {
            prodImage = productImages.get(0).getImageUrl();
        }
        return new OrderListDto.Builder(item.getOrder().getId(), item.getOrder().getCashAmt()).attributes(item.getAttributes()).prodName(item.getProductName()).prodImg(prodImage).quantity(item.getQuantity()).status(item.getStatus()).build();
    }

    private OrderItem.Status inStatus(String status) {
        for (OrderItem.Status orderItemStatus : OrderItem.userCanSeeStatus) {
            if (!orderItemStatus.toString().equals(status)) continue;
            return orderItemStatus;
        }
        return null;
    }

    @Override
    public Object details(Long orderId) {
        Order order = (Order)this.orderService.getById(orderId);
        if (order == null) {
            return StatusDto.buildDataFailureStatusDto("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u8981\u67e5\u770b\u7684\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        order.setItems(this.orderItemService.findByOrderId(order.getId()));
        this.orderService.buildOrderItems(Lists.newArrayList((Object[])new Order[]{order}), true, null);
        OrderDetailsDto orderDetails = this.buildOrderDetailDto(order);
        return StatusDto.buildDataSuccessStatusDto("\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u6210\u529f\uff01", orderDetails);
    }

    private OrderDetailsDto buildOrderDetailDto(Order order) {
        HashMap address = Maps.newHashMap();
        if (order.getOrderAddress() != null) {
            address.put("name", order.getOrderAddress().getConsignee());
            address.put("phone", order.getOrderAddress().getMobile());
            address.put("addressDetail", order.getOrderAddress().getProvince() + order.getOrderAddress().getAddress());
        }
        OrderItem.Status status = null;
        ArrayList items = Lists.newArrayList();
        for (OrderItem item : order.getItems()) {
            HashMap itemInfo = Maps.newHashMap();
            itemInfo.put("itemId", item.getId());
            itemInfo.put("prodImg", item.getSku().getPreviewImagePath());
            itemInfo.put("attributes", item.getAttributes());
            itemInfo.put("quantity", item.getQuantity());
            status = item.getStatus();
            items.add(itemInfo);
        }
        return new OrderDetailsDto.Builder(order.getId(), order.getOrderCode()).address(address).items(items).amount(order.getCashAmt()).createTime(order.getCreateTime()).status(status).build();
    }

    @Override
    public Object cancel(Long orderId, String cancelReason) {
        Order order = (Order)this.orderService.getById(orderId);
        if (order == null) {
            return StatusDto.buildDataFailureStatusDto("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u8981\u53d6\u6d88\u7684\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        order.setItems(this.orderItemService.findByOrderId(order.getId()));
        if (!this.isCanOperate(order, OrderItem.Status.NOT_PAID, OrderItem.AdmStatus.NOT_PAID)) {
            return StatusDto.buildDataFailureStatusDto("\u8be5\u8ba2\u5355\u4e0d\u80fd\u53d6\u6d88\uff01");
        }
        for (OrderItem item : order.getItems()) {
            item.setStatus(OrderItem.Status.CANCELED);
            item.setAdmStatus(OrderItem.AdmStatus.CANCELED);
            this.orderItemService.update(item);
        }
        order.setCancelReason(cancelReason);
        this.orderService.update(order);
        this.orderService.releaseOrOccupyStockByOrderId(orderId, 1);
        return StatusDto.buildSuccessStatusDto("\u8ba2\u5355\u53d6\u6d88\u6210\u529f\uff01");
    }

    private boolean isCanOperate(Order order, OrderItem.Status status, OrderItem.AdmStatus admStatus) {
        if (order != null && order.getItems() != null) {
            for (OrderItem item : order.getItems()) {
                if (status != null && !status.equals((Object)item.getStatus())) {
                    return false;
                }
                if (admStatus == null || admStatus.equals((Object)item.getAdmStatus())) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Object delete(Long orderId) {
        Order order = (Order)this.orderService.getById(orderId);
        if (order == null) {
            return StatusDto.buildDataFailureStatusDto("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u8981\u5220\u9664\u7684\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        order.setItems(this.orderItemService.findByOrderId(order.getId()));
        if (!this.isCanOperate(order, null, OrderItem.AdmStatus.FINISH)) {
            return StatusDto.buildDataFailureStatusDto("\u8be5\u8ba2\u5355\u4e0d\u80fd\u5220\u9664\uff01");
        }
        for (OrderItem item : order.getItems()) {
            item.setStatus(OrderItem.Status.DELETED);
            this.orderItemService.update(item);
        }
        return StatusDto.buildSuccessStatusDto("\u5220\u9664\u8ba2\u5355\u6210\u529f\uff01");
    }

    @Override
    public Object remindShipments(Long orderId) {
        return StatusDto.buildSuccessStatusDto("\u5df2\u7ecf\u63d0\u9192\u5356\u5bb6\u53d1\u8d27\uff01");
    }

    @Override
    public Object confirmDelivery(Long orderId) {
        Order order = (Order)this.orderService.getById(orderId);
        if (order == null) {
            return StatusDto.buildDataFailureStatusDto("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u8981\u786e\u8ba4\u6536\u8d27\u7684\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        order.setItems(this.orderItemService.findByOrderId(order.getId()));
        if (!this.isCanOperate(order, OrderItem.Status.RECEIVING, null)) {
            return StatusDto.buildDataFailureStatusDto("\u5bf9\u4e0d\u8d77\uff0c\u8be5\u8ba2\u5355\u4e0d\u80fd\u786e\u8ba4\u6536\u8d27\uff01");
        }
        for (OrderItem item : order.getItems()) {
            item.setStatus(OrderItem.Status.APPRAISING);
            item.setAdmStatus(OrderItem.AdmStatus.FINISH);
            this.orderItemService.update(item);
        }
        return StatusDto.buildSuccessStatusDto("\u786e\u8ba4\u6536\u8d27\u6210\u529f\uff01");
    }
}

