/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.order;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.order.OrderDelivery;
import com.rocoinfo.rocomall.repository.order.OrderDeliveryDao;
import com.rocoinfo.rocomall.service.order.IOrderDeliveryService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OrderDeliveryService
extends CrudService<OrderDeliveryDao, OrderDelivery>
implements IOrderDeliveryService {
    @Value(value="${addr.recipient.deny.chars}")
    private String recipientDenyChars;
    @Value(value="${addr.detail.mustcontain.chars}")
    private String addrMustContainChars;
    @Value(value="${addr.detail.deny.chars}")
    private String addrDenyChars;

    @Override
    public OrderDelivery getByOrderId(long orderId) {
        return ((OrderDeliveryDao)this.entityDao).getByOrderId(orderId);
    }

    @Override
    public boolean isValid(OrderDelivery delivery) {
        String address = delivery.getAddrDetail();
        if (address == null || address.length() < 5 || StringUtils.isEmpty((CharSequence)delivery.getProvince()) || StringUtils.isEmpty((CharSequence)delivery.getCity()) || StringUtils.isEmpty((CharSequence)delivery.getCounty())) {
            return false;
        }
        if (StringUtils.containsAny((CharSequence)delivery.getRecipient(), (CharSequence)this.recipientDenyChars)) {
            return false;
        }
        String addrDenyPattern = ".*(" + this.addrDenyChars + ").*";
        String addMustContainPattern = ".*(" + this.addrMustContainChars + ").*";
        String containDigitalPattern = ".*\\d+.*";
        if (address.matches(addrDenyPattern)) {
            return false;
        }
        if (!address.matches(addMustContainPattern)) {
            return false;
        }
        return address.matches(containDigitalPattern) && address.matches(".*(\u516c\u53f8|\u653f\u5e9c|\u5c40|\u5b66\u6821|\u5927\u53a6|\u9152\u5e97|\u533b\u9662).*");
    }
}

