/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.order;

import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.dto.DeductParam;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Address;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.dict.DictPlatform;
import com.rocoinfo.rocomall.entity.order.Order;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.repository.order.OrderDao;
import com.rocoinfo.rocomall.service.ICartService;
import com.rocoinfo.rocomall.service.IUserService;
import com.rocoinfo.rocomall.service.cent.ICentsService;
import com.rocoinfo.rocomall.service.impl.AddressService;
import com.rocoinfo.rocomall.service.impl.order.OrderDeliveryService;
import com.rocoinfo.rocomall.service.impl.product.ProductService;
import com.rocoinfo.rocomall.service.order.IOrderItemService;
import com.rocoinfo.rocomall.service.order.IOrderService;
import com.rocoinfo.rocomall.service.product.ISkuMetaService;
import com.rocoinfo.rocomall.service.product.ISkuService;
import com.rocoinfo.rocomall.service.product.ISupplierService;
import com.rocoinfo.rocomall.utils.CodeGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springside.modules.utils.Collections3;

@Service
public class OrderService
extends CrudService<OrderDao, Order>
implements IOrderService {
    @Autowired
    private IOrderItemService orderItemService;
    @Autowired
    private AddressService addressService;
    @Autowired
    private ISkuService skuService;
    @Autowired
    private ProductService productService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private ISkuMetaService skuMetaService;
    @Autowired
    private OrderDeliveryService orderDeliveryService;
    @Autowired
    private ICartService cartService;
    @Autowired
    private ICentsService centsService;
    @Autowired
    private IUserService userService;
    @Autowired
    private CodeGenerator codeGenerator;

    @Override
    public void releaseOrOccupyStockByOrderId(Long orderId, int operateFlag) {
        List<OrderItem> itemList = this.orderItemService.findByOrderId(orderId);
        if (!CollectionUtils.isEmpty(itemList)) {
            ArrayList skuIdList = Lists.newArrayListWithCapacity((int)itemList.size());
            ArrayList qtyList = Lists.newArrayListWithCapacity((int)itemList.size());
            for (OrderItem item : itemList) {
                skuIdList.add(item.getSku().getId());
                if (operateFlag == 1) {
                    qtyList.add(-item.getQuantity().intValue());
                    continue;
                }
                if (operateFlag != 2) continue;
                qtyList.add(item.getQuantity());
            }
            this.skuService.incrOrDecrOccupiedStock(skuIdList, qtyList);
        }
    }

    @Override
    public void insert(Order order) {
        super.insert(order);
        String consumeTypeCode = OrderItem.OrderType.common.getCode();
        if (!CollectionUtils.isEmpty(order.getItems())) {
            consumeTypeCode = ((OrderItem)Collections3.getFirst(order.getItems())).getOrderType().getCode();
            for (OrderItem item : order.getItems()) {
                this.orderItemService.insert(item);
            }
            ArrayList skuIdList = Lists.newArrayList();
            ArrayList qtyList = Lists.newArrayList();
            for (OrderItem item : order.getItems()) {
                skuIdList.add(item.getSku().getId());
                qtyList.add(item.getQuantity());
            }
            this.skuService.batchIncreaseOccupiedStockAndSaleVolumeOnPayed(skuIdList, qtyList);
            this.orderDeliveryService.insert(order.getDelivery());
        }
    }

    public Page<Order> searchOrder(Map<String, Object> params, Pageable pageable) {
        List<Order> orders = Collections.emptyList();
        Long count = ((OrderDao)this.entityDao).searchTotal(params);
        if (count > (long)pageable.getOffset()) {
            params.put("offset", pageable.getOffset());
            params.put("pageSize", pageable.getPageSize());
            params.put("sort", pageable.getSort());
            orders = ((OrderDao)this.entityDao).search(params);
            this.buildOrderItems(orders, true, params);
        }
        return new PageImpl(orders, pageable, count.longValue());
    }

    @Override
    public void buildOrderItems(List<Order> orderList, boolean isLoadImg, Map<String, Object> params) {
        if (!CollectionUtils.isEmpty(orderList)) {
            List<OrderItem> itemList = this.orderItemService.findWithSkuByOrderIdsIn(Collections3.extractToList(orderList, (String)"id"));
            String status = "status";
            ArrayList skuList = Lists.newArrayList();
            String itemStatus = null;
            if (params != null && params.containsKey("status")) {
                itemStatus = params.get("status").toString();
            }
            for (Order order : orderList) {
                order.setItems(null);
                Iterator<OrderItem> iter = itemList.iterator();
                while (iter.hasNext()) {
                    OrderItem orderItem = iter.next();
                    if (!orderItem.getOrder().getId().equals(order.getId())) continue;
                    Sku itemSku = orderItem.getSku();
                    itemSku.getProduct().setSkuMeta(this.skuMetaService.getByProductId(itemSku.getProduct().getId()));
                    orderItem.setSku(itemSku);
                    if (StringUtils.isNotEmpty((CharSequence)itemStatus) && orderItem.getStatus().toString().equals(itemStatus)) {
                        order.addItem(orderItem);
                    } else if (StringUtils.isEmpty((CharSequence)itemStatus)) {
                        order.addItem(orderItem);
                    }
                    skuList.add(orderItem.getSku());
                    iter.remove();
                }
            }
            if (isLoadImg) {
                this.skuService.loadImages(skuList);
            }
            Iterator<Order> iterator = orderList.iterator();
            while (iterator.hasNext()) {
                Order orderInfo = iterator.next();
                Address address = (Address)this.addressService.getById(orderInfo.getAddressId());
                orderInfo.setOrderAddress(address);
                if (!Collections3.isEmpty(orderInfo.getItems())) continue;
                iterator.remove();
                orderList.remove(orderInfo);
            }
        }
    }

    @Override
    public Order getByOrderNo(String orderNo) {
        Order order = null;
        if (StringUtils.isNotBlank((CharSequence)orderNo)) {
            order = ((OrderDao)this.entityDao).getByOrderNo(orderNo);
        }
        return order;
    }

    @Override
    public void saveCartOrder(Order order, Long loggedUserId) {
        ((OrderDao)this.entityDao).insert(order);
        String consumeTypeCode = OrderItem.OrderType.common.getCode();
        if (!CollectionUtils.isEmpty(order.getItems())) {
            consumeTypeCode = ((OrderItem)Collections3.getFirst(order.getItems())).getOrderType().getCode();
            this.orderItemService.insertItems(order.getItems());
            ArrayList skuIdList = Lists.newArrayList();
            ArrayList qtyList = Lists.newArrayList();
            for (OrderItem item : order.getItems()) {
                skuIdList.add(item.getSku().getId());
                qtyList.add(item.getQuantity());
            }
            this.skuService.batchIncreaseOccupiedStockAndSaleVolumeOnPayed(skuIdList, qtyList);
            this.cartService.removeCartItemUnitProdId(order.getUser().getId(), skuIdList.toArray(new Long[0]));
        }
        this.payOrder(order, consumeTypeCode, loggedUserId);
    }

    @Override
    public Page<Order> searchOrder(Map<String, Object> parameters, PageRequest pageable) {
        List<Order> orders = Collections.emptyList();
        Long count = ((OrderDao)this.entityDao).searchTotal(parameters);
        if (count > (long)pageable.getOffset()) {
            parameters.put("offset", pageable.getOffset());
            parameters.put("pageSize", pageable.getPageSize());
            parameters.put("sort", pageable.getSort());
            orders = ((OrderDao)this.entityDao).search(parameters);
            this.buildOrderItems(orders, true, parameters);
        }
        return new PageImpl(orders, (Pageable)pageable, count.longValue());
    }

    private StatusDto payOrder(Order order, String consumeTypeCode, Long loggedUserId) {
        DeductParam param = new DeductParam();
        param.setConsumeTypeCode(consumeTypeCode);
        param.setCent(order.getCent());
        param.setEntityId(order.getId());
        param.setUserId(order.getUser().getId());
        param.setPlatformCode(DictPlatform.CENT_PLATFORM.getCode());
        return this.centsService.deductCent(param, loggedUserId);
    }
}

